/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.genee.io.util.ToStringUtil;

public class OrPredicate<T>
implements Predicate<T>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Iterable<? extends Predicate<? super T>> components;

    private OrPredicate(Iterable<? extends Predicate<? super T>> components) {
        this.components = components;
    }

    public boolean apply(T t) {
        for (Predicate<? super T> predicate : this.components) {
            if (!predicate.apply(t)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrPredicate) {
            OrPredicate that = (OrPredicate)obj;
            return OrPredicate.iterableElementsEqual(this.components, that.components);
        }
        return false;
    }

    public Iterable<? extends Predicate<? super T>> getComponents() {
        return this.components;
    }

    public int hashCode() {
        int result = 0;
        for (Predicate<T> predicate : this.components) {
            result |= predicate.hashCode();
        }
        return result;
    }

    public String toString() {
        return "Or(" + ToStringUtil.toString(this.components, ",") + ")";
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate<T>(OrPredicate.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return new OrPredicate<T>(OrPredicate.defensiveCopy(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return new OrPredicate<T>(OrPredicate.asList((Predicate)Preconditions.checkNotNull(first), (Predicate)Preconditions.checkNotNull(second)));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (T element : iterable) {
            list.add(Preconditions.checkNotNull(element));
        }
        return list;
    }

    private static <T> List<Predicate<? super T>> asList(Predicate first, Predicate second) {
        return Arrays.asList(first, second);
    }

    private static <T> List<T> defensiveCopy(T ... array) {
        return OrPredicate.defensiveCopy(Arrays.asList(array));
    }

    private static boolean iterableElementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> iterator1 = iterable1.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator1.next().equals(iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }
}

