/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.chart.ConditionalDrawingOptionsPanel;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.filter.GT;
import org.broadinstitute.genee.filter.LT;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public class RangeFilterComponent
extends JPanel
implements FilterComponent {
    private Filters.RangeFilter rangeFilter;

    public RangeFilterComponent(Filters.RangeFilter _rangeFilter) {
        this.rangeFilter = _rangeFilter;
        final JComboBox lowerComboBox = UIUtil.createComboBox(new BasicMapEntry[]{new BasicMapEntry<Integer>(">", 0), new BasicMapEntry<Integer>(">=", 2)});
        lowerComboBox.setSelectedIndex(_rangeFilter.f1 instanceof GT ? 0 : 1);
        lowerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float val = ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1.getValue();
                ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1 = ConditionalDrawingOptionsPanel.BetweenFilterPanel.createAbstractFloatFilter((Integer)((BasicMapEntry)lowerComboBox.getSelectedItem()).getValue());
                System.out.println(((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1.getClass());
                ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1.setValue(val);
                RangeFilterComponent.this.rangeFilter.fireFilterChanged();
            }
        });
        final JComboBox upperComboBox = UIUtil.createComboBox(new BasicMapEntry[]{new BasicMapEntry<Integer>("<", 1), new BasicMapEntry<Integer>("<=", 3)});
        upperComboBox.setSelectedIndex(_rangeFilter.f2 instanceof LT ? 0 : 1);
        upperComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float val = ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f2.getValue();
                ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f2 = ConditionalDrawingOptionsPanel.BetweenFilterPanel.createAbstractFloatFilter((Integer)((BasicMapEntry)upperComboBox.getSelectedItem()).getValue());
                ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f2.setValue(val);
                RangeFilterComponent.this.rangeFilter.fireFilterChanged();
            }
        });
        this.rangeFilter.f1 = ConditionalDrawingOptionsPanel.BetweenFilterPanel.createAbstractFloatFilter((Integer)((BasicMapEntry)lowerComboBox.getSelectedItem()).getValue());
        this.rangeFilter.f2 = ConditionalDrawingOptionsPanel.BetweenFilterPanel.createAbstractFloatFilter((Integer)((BasicMapEntry)upperComboBox.getSelectedItem()).getValue());
        CellConstraints cc = new CellConstraints();
        TimerTextField lowerValueTextField = new TimerTextField(Float.isNaN(this.rangeFilter.f1.getValue()) ? "" : Formatter.toString(Float.valueOf(this.rangeFilter.f1.getValue()))){

            @Override
            public void update() {
                try {
                    String text = this.getText();
                    if (text != null) {
                        ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1.setValue(ParserHelper.parseFloat(text.trim()));
                    } else {
                        ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1.setValue(Float.NaN);
                    }
                }
                catch (NumberFormatException nfe) {
                    ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f1.setValue(Float.NaN);
                }
                RangeFilterComponent.this.rangeFilter.fireFilterChanged();
            }
        };
        TimerTextField upperValueTextField = new TimerTextField(Float.isNaN(this.rangeFilter.f2.getValue()) ? "" : Formatter.toString(Float.valueOf(this.rangeFilter.f2.getValue()))){

            @Override
            public void update() {
                try {
                    String text = this.getText();
                    if (text != null) {
                        ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f2.setValue(ParserHelper.parseFloat(text.trim()));
                    } else {
                        ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f2.setValue(Float.NaN);
                    }
                }
                catch (NumberFormatException nfe) {
                    ((RangeFilterComponent)RangeFilterComponent.this).rangeFilter.f2.setValue(Float.NaN);
                }
                RangeFilterComponent.this.rangeFilter.fireFilterChanged();
            }
        };
        this.setLayout((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(5), "p"));
        this.add((Component)lowerComboBox, cc.xy(1, 1));
        this.add((Component)lowerValueTextField, cc.xy(3, 1));
        this.add((Component)new JLabel("and"), cc.xy(5, 1));
        this.add((Component)upperComboBox, cc.xy(7, 1));
        this.add((Component)upperValueTextField, cc.xy(9, 1));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Filter getFilter() {
        return this.rangeFilter;
    }
}

