/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.filter.FilterComponent;
import org.broadinstitute.genee.filter.Filters;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class TopFilterComponent
extends JPanel
implements FilterComponent {
    private Filters.TopFilter filter;

    public TopFilterComponent(Filters.TopFilter filter) {
        this.filter = filter;
        CellConstraints cc = new CellConstraints();
        TimerTextField valueTextField = new TimerTextField(!filter.isEmpty() ? "" + filter.getN() : ""){

            @Override
            public void update() {
                try {
                    String text = this.getText();
                    if (text != null) {
                        TopFilterComponent.this.setValue(ParserHelper.parseInt(text.trim()));
                    } else {
                        TopFilterComponent.this.setValue(-1);
                    }
                }
                catch (NumberFormatException nfe) {
                    TopFilterComponent.this.setValue(-1);
                }
            }
        };
        FormLayout fl = new FormLayout(UIUtil.createColumnStringForFormLayout(7), "p, 6px, p");
        this.setLayout((LayoutManager)fl);
        this.add((Component)new JLabel("Top"), cc.xy(1, 1));
        this.add((Component)valueTextField, cc.xy(3, 1));
        final JComboBox topOrBottomComboBox = UIUtil.createComboBox(new Object[]{"lowest", "highest"});
        topOrBottomComboBox.setSelectedIndex(filter.isEmpty() ? 1 : (filter.isTop() ? 1 : 0));
        topOrBottomComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFilterComponent.this.setTop(topOrBottomComboBox.getSelectedIndex() == 1);
            }
        });
        this.add((Component)topOrBottomComboBox, cc.xy(5, 1));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String toString() {
        return "Top";
    }

    protected void setTop(boolean top) {
        this.filter.setTop(top);
    }

    protected void setValue(int value) {
        this.filter.setN(value);
    }
}

