/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.filter.TopIndexedFilter;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class TopFilterUI
implements FilterUI {
    private String filterName;
    private JPanel panel;
    private JComboBox topOrBottomComboBox;
    private JTextField nTextField;
    private boolean savedTop;
    private int savedN;
    private Comparator c;

    public TopFilterUI(String filterName, Comparator c) {
        this.filterName = filterName;
        this.c = c;
        this.topOrBottomComboBox = UIUtil.createComboBox(new Object[]{"bottom", "top"});
        this.topOrBottomComboBox.setSelectedIndex(1);
        this.nTextField = new JTextField("50", 14);
        this.savedN = 50;
        this.savedTop = true;
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addFirstColumn(this.topOrBottomComboBox);
        formBuilder.add(this.nTextField);
        this.panel = formBuilder.getPanel();
    }

    @Override
    public IndexedFilter apply() {
        this.savedTop = this.topOrBottomComboBox.getSelectedIndex() == 1;
        try {
            this.savedN = ParserHelper.parseInt(this.nTextField.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TopIndexedFilter(this.savedTop, this.savedN, this.c);
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.panel;
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public void cancel() {
        this.topOrBottomComboBox.setSelectedIndex(this.savedTop ? 1 : 0);
        this.nTextField.setText(String.valueOf(this.savedN));
    }
}

