/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.matrix.Vector;

public class TopIndexedFilter
implements IndexedFilter {
    private Comparator c;
    private Object cutoff;
    private Vector filterValueProvider;
    private int n;
    private boolean top;

    public TopIndexedFilter(boolean top, int n, Comparator c) {
        this.top = top;
        this.n = n;
        if (top) {
            c = Collections.reverseOrder(c);
        }
        this.c = c;
    }

    @Override
    public boolean accept(int index) {
        Object value = this.filterValueProvider.getValue(index);
        return this.c.compare(this.cutoff, value) > 0;
    }

    @Override
    public void setVector(Vector filterValueProvider) {
        this.filterValueProvider = filterValueProvider;
        ArrayList<Object> list = new ArrayList<Object>();
        int rows = filterValueProvider.size();
        for (int i = 0; i < rows; ++i) {
            Object value = filterValueProvider.getValue(i);
            if (value == null) continue;
            list.add(value);
        }
        Collections.sort(list, this.c);
        this.cutoff = list.get(this.n);
    }
}

