/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import org.broadinstitute.genee.gsea.Gsea;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.ShortListView;
import org.broadinstitute.genee.matrix.SlicedFloatList;
import org.broadinstitute.genee.stats.Sorting;

public class CmapScore {
    private DatasetColumnView dnRanksColumnView;
    private ShortListView dnRanksView;
    private DatasetColumnView dnScoresColumnView;
    private SlicedFloatList dnScoresView;
    private Gsea gsea;
    private float n;
    private DatasetColumnView upRanksColumnView;
    private ShortListView upRanksView;
    private DatasetColumnView upScoresColumnView;
    private SlicedFloatList upScoresView;
    private float[] result;

    public CmapScore(float p, Dataset upScores, Dataset dnScores, Dataset upRanks, Dataset dnRanks, float n) {
        this.n = n;
        this.gsea = new Gsea(p);
        this.upRanksColumnView = new DatasetColumnView(upRanks);
        this.dnRanksColumnView = new DatasetColumnView(dnRanks);
        this.upScoresColumnView = new DatasetColumnView(upScores);
        this.dnScoresColumnView = new DatasetColumnView(dnScores);
        this.upScoresView = new SlicedFloatList(this.upScoresColumnView, null);
        this.dnScoresView = new SlicedFloatList(this.dnScoresColumnView, null);
        this.upRanksView = new ShortListView(this.upRanksColumnView, null);
        this.dnRanksView = new ShortListView(this.dnRanksColumnView, null);
        this.result = new float[3];
    }

    public float[] execute(int columnIndex) {
        this.upRanksColumnView.setIndex(columnIndex);
        this.dnRanksColumnView.setIndex(columnIndex);
        this.upScoresColumnView.setIndex(columnIndex);
        this.dnScoresColumnView.setIndex(columnIndex);
        this.upScoresView.setIndices(Sorting.index(this.upRanksColumnView, true));
        this.dnScoresView.setIndices(Sorting.index(this.dnRanksColumnView, true));
        this.upRanksView.setIndices(this.upScoresView.getIndices());
        this.dnRanksView.setIndices(this.dnScoresView.getIndices());
        float upScore = this.gsea.execute(this.n, this.upRanksView, this.upScoresView);
        float dnScore = this.gsea.execute(this.n, this.dnRanksView, this.dnScoresView);
        this.result[0] = upScore;
        this.result[1] = dnScore;
        this.result[2] = CmapScore.getCombinedScore(upScore, dnScore);
        return this.result;
    }

    public static float getCombinedScore(float up, float down) {
        if (up > 0.0f && down > 0.0f || up < 0.0f && down < 0.0f) {
            return 0.0f;
        }
        return (up - down) / 2.0f;
    }
}

