/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.gsea.GctxIndexHelper;
import org.broadinstitute.genee.gsea.Gsea;
import org.broadinstitute.genee.gsea.KSElement;
import org.broadinstitute.genee.io.matrix.gctx.DatasetColumnChunkIterator;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.ArrayShortList;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.ShortList;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.stats.Sorting;

public class FileBackedGsea
implements Iterator<Object> {
    private int[] dnRankIndicesIntoSubset;
    private ShortList dnRanks;
    private short[] dnRanksToFill;
    private int[] dnScoreIndicesIntoSubset;
    private FloatList dnScores;
    private float[] dnScoresToFill;
    private Gsea gsea;
    private int n;
    private Collection<String> notFoundIds;
    private Iterator<FloatList> ranksIterator;
    private GctxReader ranksReader;
    private Vector ranksRowIds;
    private Iterator<FloatList> scoresIterator;
    private GctxReader scoresReader;
    private boolean storeRunningEs;
    private int[] upRankIndicesIntoSubset;
    private ShortList upRanks;
    private short[] upRanksToFill;
    private int[] upScoreIndicesIntoSubset;
    private FloatList upScores;
    private float[] upScoresToFill;
    private boolean columnIndicesAreAscending;

    public FileBackedGsea(float p, String scoresFile, String ranksFile, int[] columnIndices, Set<String> up, Set<String> dn, boolean storeRunningEs, boolean ranksAndScoresRowIdsAreInSameOrder, boolean columnIndicesAreAscending) throws IOException {
        GctxIndexHelper scoresIndexHelper;
        this.columnIndicesAreAscending = columnIndicesAreAscending;
        for (String id : up) {
            if (!dn.contains(id)) continue;
            throw new IOException(id + " was found in the up and down sets in your signature.");
        }
        this.storeRunningEs = storeRunningEs;
        this.ranksReader = new GctxReader(ranksFile);
        this.scoresReader = new GctxReader(scoresFile);
        this.ranksRowIds = this.ranksReader.getRowsOrColumns(true).get(0);
        Map rankRowIdToIndex = VectorUtil.createValueToIndexMap(this.ranksRowIds);
        TIntArrayList rankUpIndices = new TIntArrayList();
        this.notFoundIds = new HashSet<String>();
        for (String id : up) {
            Integer index = rankRowIdToIndex.get(id);
            if (index != null) {
                rankUpIndices.add(index.intValue());
                continue;
            }
            this.notFoundIds.add(id);
        }
        TIntArrayList rankDnIndices = new TIntArrayList();
        for (String id : dn) {
            Integer index = rankRowIdToIndex.get(id);
            if (index != null) {
                rankDnIndices.add(index.intValue());
                continue;
            }
            this.notFoundIds.add(id);
        }
        if (rankUpIndices.size() + rankDnIndices.size() == 0) {
            throw new IOException("No ids in your input signature were found in the database.");
        }
        if (rankUpIndices.size() == 0) {
            throw new IOException("No ids in your up signature were found in the database.");
        }
        if (rankDnIndices.size() == 0) {
            throw new IOException("No ids in your down signature were found in the database.");
        }
        this.n = this.ranksReader.getDatasetInfo().nrows;
        GctxIndexHelper ranksIndexHelper = new GctxIndexHelper(rankUpIndices.iterator(), rankDnIndices.iterator());
        if (ranksAndScoresRowIdsAreInSameOrder) {
            scoresIndexHelper = ranksIndexHelper;
        } else {
            Map scoreRowIdToIndex = VectorUtil.createValueToIndexMap(this.scoresReader.getRowsOrColumns(true).get(0));
            TIntArrayList scoreUpIndices = new TIntArrayList();
            for (String id : up) {
                if (this.notFoundIds.contains(id)) continue;
                scoreUpIndices.add(scoreRowIdToIndex.get(id).intValue());
            }
            TIntArrayList scoreDnIndices = new TIntArrayList();
            for (String id : dn) {
                if (this.notFoundIds.contains(id)) continue;
                scoreDnIndices.add(scoreRowIdToIndex.get(id).intValue());
            }
            scoresIndexHelper = new GctxIndexHelper(scoreUpIndices.iterator(), scoreDnIndices.iterator());
        }
        this.ranksIterator = new DatasetColumnChunkIterator(this.ranksReader, ranksIndexHelper.getRowIndices(), columnIndices, true, columnIndicesAreAscending);
        if (p == 0.0f) {
            final ArrayFloatList dummy = new ArrayFloatList(ranksIndexHelper.getRowIndices().length);
            this.scoresIterator = new Iterator<FloatList>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public FloatList next() {
                    return dummy;
                }

                @Override
                public void remove() {
                }
            };
        } else {
            this.scoresIterator = new DatasetColumnChunkIterator(this.scoresReader, scoresIndexHelper.getRowIndices(), columnIndices, true, columnIndicesAreAscending);
        }
        this.upRankIndicesIntoSubset = ranksIndexHelper.getUpIndicesIntoSubset();
        this.dnRankIndicesIntoSubset = ranksIndexHelper.getDnIndicesIntoSubset();
        this.upScoreIndicesIntoSubset = scoresIndexHelper.getUpIndicesIntoSubset();
        this.dnScoreIndicesIntoSubset = scoresIndexHelper.getDnIndicesIntoSubset();
        this.upRanksToFill = new short[this.upRankIndicesIntoSubset.length];
        this.dnRanksToFill = new short[this.dnRankIndicesIntoSubset.length];
        this.upScoresToFill = new float[this.upRankIndicesIntoSubset.length];
        this.dnScoresToFill = new float[this.dnRankIndicesIntoSubset.length];
        this.upRanks = new ArrayShortList(this.upRankIndicesIntoSubset.length);
        this.dnRanks = new ArrayShortList(this.dnRankIndicesIntoSubset.length);
        this.upScores = new ArrayFloatList(this.upRankIndicesIntoSubset.length);
        this.dnScores = new ArrayFloatList(this.dnRankIndicesIntoSubset.length);
        this.gsea = new Gsea(p);
    }

    public int getDnCount() {
        return this.dnRanksToFill.length;
    }

    public int getUpCount() {
        return this.upRanksToFill.length;
    }

    public void close() {
        this.ranksReader.close();
        this.scoresReader.close();
    }

    public Collection<String> getNotFoundIds() {
        return this.notFoundIds;
    }

    @Override
    public boolean hasNext() {
        return this.ranksIterator.hasNext();
    }

    public Iterator<FloatList> getRanksIterator() {
        return this.ranksIterator;
    }

    @Override
    public Object next() {
        int offset;
        int nUp = this.upScores.size();
        int nDn = this.dnScores.size();
        FloatList rankColumn = this.ranksIterator.next();
        FloatList scoresColumn = this.scoresIterator.next();
        GctxIndexHelper.extractShorts(rankColumn, this.upRankIndicesIntoSubset, this.upRanksToFill);
        GctxIndexHelper.extractFloats(scoresColumn, this.upScoreIndicesIntoSubset, this.upScoresToFill);
        int[] upIdx = Sorting.index(this.upRanksToFill, true);
        for (int i = 0; i < nUp; ++i) {
            this.upRanks.setValue(i, this.upRanksToFill[upIdx[i]]);
            this.upScores.setValue(i, this.upScoresToFill[upIdx[i]]);
        }
        GctxIndexHelper.extractShorts(rankColumn, this.dnRankIndicesIntoSubset, this.dnRanksToFill);
        GctxIndexHelper.extractFloats(scoresColumn, this.dnScoreIndicesIntoSubset, this.dnScoresToFill);
        int[] dnIdx = Sorting.index(this.dnRanksToFill, true);
        for (int i = 0; i < nDn; ++i) {
            this.dnRanks.setValue(i, this.dnRanksToFill[dnIdx[i]]);
            this.dnScores.setValue(i, this.dnScoresToFill[dnIdx[i]]);
        }
        if (!this.storeRunningEs) {
            float upScore = this.gsea.execute(this.n, this.upRanks, this.upScores);
            float dnScore = this.gsea.execute(this.n, this.dnRanks, this.dnScores);
            return new float[]{upScore, dnScore};
        }
        KSElement[] upScore = this.gsea.runningScore(this.n, this.upRanks, this.upScores);
        for (int i = offset = 1; i < nUp - offset; ++i) {
            upScore[i].setId((String)this.ranksRowIds.getValue(this.upRankIndicesIntoSubset[upIdx[i - offset]]));
        }
        KSElement[] dnScore = this.gsea.runningScore(this.n, this.dnRanks, this.dnScores);
        for (int i = offset; i < nDn - offset; ++i) {
            dnScore[i].setId((String)this.ranksRowIds.getValue(this.dnRankIndicesIntoSubset[dnIdx[i - offset]]));
        }
        return new Object[]{upScore, dnScore};
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

