/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.broadinstitute.genee.matrix.FloatList;

public class GctxIndexHelper {
    private int[] dnIndicesIntoSubset;
    private int[] rowIndices;
    private int[] upIndicesIntoSubset;

    public GctxIndexHelper(TIntIterator upIndices, TIntIterator dnIndices) {
        ArrayList<IndexDirectionPair> allIndices = new ArrayList<IndexDirectionPair>();
        while (upIndices.hasNext()) {
            allIndices.add(new IndexDirectionPair(true, upIndices.next()));
        }
        while (dnIndices.hasNext()) {
            allIndices.add(new IndexDirectionPair(false, dnIndices.next()));
        }
        Collections.sort(allIndices, new Comparator<IndexDirectionPair>(){

            @Override
            public int compare(IndexDirectionPair o1, IndexDirectionPair o2) {
                int anotherVal;
                int thisVal = o1.index;
                return thisVal < (anotherVal = o2.index) ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
        });
        TIntArrayList upSubset = new TIntArrayList();
        TIntArrayList dnSubset = new TIntArrayList();
        this.rowIndices = new int[allIndices.size()];
        int length = allIndices.size();
        for (int i = 0; i < length; ++i) {
            IndexDirectionPair pair = (IndexDirectionPair)allIndices.get(i);
            if (pair.up) {
                upSubset.add(i);
            } else {
                dnSubset.add(i);
            }
            this.rowIndices[i] = pair.index;
        }
        this.upIndicesIntoSubset = upSubset.toArray();
        this.dnIndicesIntoSubset = dnSubset.toArray();
    }

    public int[] getDnIndicesIntoSubset() {
        return this.dnIndicesIntoSubset;
    }

    public int[] getRowIndices() {
        return this.rowIndices;
    }

    public int[] getUpIndicesIntoSubset() {
        return this.upIndicesIntoSubset;
    }

    public static float[] extractFloats(FloatList column, int[] indices, float[] arrayToFill) {
        int length = indices.length;
        for (int i = 0; i < length; ++i) {
            arrayToFill[i] = column.getValue(indices[i]);
        }
        return arrayToFill;
    }

    public static int[] extractInts(FloatList column, int[] indices, int[] arrayToFill) {
        int length = indices.length;
        for (int i = 0; i < length; ++i) {
            arrayToFill[i] = (int)column.getValue(indices[i]);
        }
        return arrayToFill;
    }

    public static short[] extractShorts(FloatList column, int[] indices, short[] arrayToFill) {
        int length = indices.length;
        for (int i = 0; i < length; ++i) {
            arrayToFill[i] = (short)column.getValue(indices[i]);
        }
        return arrayToFill;
    }

    private static class IndexDirectionPair {
        private int index;
        private boolean up;

        public IndexDirectionPair(boolean up, int index) {
            this.up = up;
            this.index = index;
        }

        public String toString() {
            return this.up + ", " + this.index;
        }
    }
}

