/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import java.io.IOException;
import java.util.Iterator;
import org.broadinstitute.genee.gsea.Gsea;
import org.broadinstitute.genee.gsea.KSElement;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.ShortListView;
import org.broadinstitute.genee.matrix.SlicedFloatList;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.Sorting;

public class InMemoryGsea
implements Iterator<Object> {
    private int columnIndex;
    private Vector dnIds;
    private DatasetColumnView dnRanksColumnView;
    private ShortListView dnRanksView;
    private DatasetColumnView dnScoresColumnView;
    private SlicedFloatList dnScoresView;
    private Gsea gsea;
    private float n;
    private int ncols;
    private int nDn;
    private int nUp;
    private boolean storeRunningEs;
    private Vector upIds;
    private DatasetColumnView upRanksColumnView;
    private ShortListView upRanksView;
    private DatasetColumnView upScoresColumnView;
    private SlicedFloatList upScoresView;

    public InMemoryGsea(float p, Dataset upScores, Dataset dnScores, Dataset upRanks, Dataset dnRanks, float n, boolean storeRunningEs) throws IOException {
        this.nUp = upScores.getRowCount();
        this.nDn = dnScores.getRowCount();
        this.n = n;
        this.gsea = new Gsea(p);
        this.columnIndex = -1;
        this.ncols = upScores.getColumnCount();
        this.storeRunningEs = storeRunningEs;
        this.upRanksColumnView = new DatasetColumnView(upRanks);
        this.dnRanksColumnView = new DatasetColumnView(dnRanks);
        this.upScoresColumnView = new DatasetColumnView(upScores);
        this.dnScoresColumnView = new DatasetColumnView(dnScores);
        String idField = "id";
        this.upIds = this.upRanksColumnView.getDataset().getRowMetadata().get(idField);
        this.dnIds = this.dnRanksColumnView.getDataset().getRowMetadata().get(idField);
        this.upScoresView = new SlicedFloatList(this.upScoresColumnView, null);
        this.dnScoresView = new SlicedFloatList(this.dnScoresColumnView, null);
        this.upRanksView = new ShortListView(this.upRanksColumnView, null);
        this.dnRanksView = new ShortListView(this.dnRanksColumnView, null);
    }

    @Override
    public boolean hasNext() {
        return this.columnIndex < this.ncols - 1;
    }

    @Override
    public Object next() {
        ++this.columnIndex;
        this.upRanksColumnView.setIndex(this.columnIndex);
        this.dnRanksColumnView.setIndex(this.columnIndex);
        this.upScoresColumnView.setIndex(this.columnIndex);
        this.dnScoresColumnView.setIndex(this.columnIndex);
        this.upScoresView.setIndices(Sorting.index(this.upRanksColumnView, true));
        this.dnScoresView.setIndices(Sorting.index(this.dnRanksColumnView, true));
        this.upRanksView.setIndices(this.upScoresView.getIndices());
        this.dnRanksView.setIndices(this.dnScoresView.getIndices());
        if (!this.storeRunningEs) {
            float upScore = this.gsea.execute(this.n, this.upRanksView, this.upScoresView);
            float dnScore = this.gsea.execute(this.n, this.dnRanksView, this.dnScoresView);
            return new float[]{upScore, dnScore};
        }
        KSElement[] upScore = this.gsea.runningScore(this.n, this.upRanksView, this.upScoresView);
        for (int i = 0; i < this.nUp; ++i) {
            upScore[i].setId((String)this.upIds.getValue(i));
        }
        KSElement[] dnScore = this.gsea.runningScore(this.n, this.dnRanksView, this.dnScoresView);
        for (int i = 0; i < this.nDn; ++i) {
            dnScore[i].setId((String)this.dnIds.getValue(i));
        }
        return new Object[]{upScore, dnScore};
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static float getCombinedScore(float up, float down) {
        if (up > 0.0f && down > 0.0f || up < 0.0f && down < 0.0f) {
            return 0.0f;
        }
        return up - down;
    }
}

