/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.google.common.collect.Sets;
import com.jidesoft.combobox.CheckBoxListComboBox;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.StyledLabel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

abstract class AbstractComparisonComponent {
    protected boolean classAIntersection = false;
    protected boolean classBIntersection = false;
    protected boolean firstTime = true;
    protected FormBuilder groupByFormBuilder;
    protected CheckBoxListComboBox groupComparisonsByCheckBoxList;
    protected boolean inModelSpace;
    protected Project project;

    AbstractComparisonComponent(boolean inModelSpace) {
        this.inModelSpace = inModelSpace;
        this.groupByFormBuilder = new FormBuilder();
        this.groupByFormBuilder.nextRow();
        this.groupByFormBuilder.addLabel("Split comparisons by:");
        this.groupComparisonsByCheckBoxList = new CheckBoxListComboBox();
        this.groupComparisonsByCheckBoxList.setBackground(UIManager.getColor("ComboBox.background"));
        this.groupComparisonsByCheckBoxList.setEditable(false);
        this.groupComparisonsByCheckBoxList.setSelectionMode(2);
        this.groupComparisonsByCheckBoxList.setSelectedIndex(-1);
        this.groupByFormBuilder.add((Component)this.groupComparisonsByCheckBoxList);
        StyledLabel descriptionLabel = new StyledLabel(" Create a separate comparison for each unique value (e.g. split by cell annotation and auto-create separate comparisons for MCF7 and PC3");
        descriptionLabel.setLineWrap(true);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(descriptionLabel.getFont().getSize2D() - 2.0f));
        this.groupByFormBuilder.nextRowNoSpace();
        this.groupByFormBuilder.add((Component)descriptionLabel);
    }

    public abstract JComponent getJComponent();

    public abstract List<String> getSelectedFields();

    public List<String> getSplitOnFields() {
        Object[] selection = this.groupComparisonsByCheckBoxList.getSelectedObjects();
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : selection) {
            list.add((String)obj);
        }
        return list;
    }

    public TwoClassComparison[] getTwoClassComparisons() {
        Dataset dataset = this.getDataset();
        MetadataModel metadata = dataset.getColumnMetadata();
        List<String> selectedMetadataNames = this.getSelectedFields();
        List<Combination>[] selection = this.getSelectedCombinations();
        List<Combination> classOneCombinations = this.createCombinations(dataset, selection[0], selectedMetadataNames, this.classAIntersection, true);
        List<Combination> classTwoCombinations = this.createCombinations(dataset, selection[1], selectedMetadataNames, this.classBIntersection, false);
        int[] matchMetadataColumnIndices = null;
        List<String> matchOnField = this.getSplitOnFields();
        Set product = null;
        if (matchOnField != null && matchOnField.size() > 0) {
            ArrayList matchValues = new ArrayList();
            matchMetadataColumnIndices = new int[matchOnField.size()];
            for (int i = 0; i < matchOnField.size(); ++i) {
                matchMetadataColumnIndices[i] = metadata.getColumnIndex(matchOnField.get(i));
            }
            for (int matchMetadataIndex : matchMetadataColumnIndices) {
                matchValues.add(VectorUtil.getValues(metadata.get(matchMetadataIndex)));
            }
            product = Sets.cartesianProduct(matchValues);
        } else {
            product = new HashSet();
            product.add(null);
        }
        ArrayList<TwoClassComparison> comparisons = new ArrayList<TwoClassComparison>();
        for (List matchValues : product) {
            LinkedHashSet<Integer> columnsWithSameValuesForMatchOn = new LinkedHashSet<Integer>();
            if (matchValues != null) {
                int nitems = metadata.getItemCount();
                for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
                    boolean isMatch = true;
                    for (int i = 0; i < matchMetadataColumnIndices.length && isMatch; ++i) {
                        int metadataIndex = matchMetadataColumnIndices[i];
                        Object matchValue = matchValues.get(i);
                        if (!matchValue.equals(metadata.getValue(itemIndex, metadataIndex))) {
                            isMatch = false;
                        }
                        if (!isMatch) continue;
                        columnsWithSameValuesForMatchOn.add(itemIndex);
                    }
                }
            }
            for (int i = 0; i < classOneCombinations.size(); ++i) {
                Combination c1 = classOneCombinations.get(i);
                Sets.SetView classOneColumnIndices = c1.getIndices();
                if (matchValues != null) {
                    classOneColumnIndices = Sets.intersection(columnsWithSameValuesForMatchOn, classOneColumnIndices);
                }
                if (classOneColumnIndices.size() == 0) continue;
                for (int j = 0; j < classTwoCombinations.size(); ++j) {
                    Combination c2 = classTwoCombinations.get(j);
                    Sets.SetView classTwoColumnIndices = c2.getIndices();
                    if (matchValues != null) {
                        classTwoColumnIndices = Sets.intersection(columnsWithSameValuesForMatchOn, classTwoColumnIndices);
                    }
                    if (classTwoColumnIndices.size() == 0) continue;
                    StringBuilder comparisonName = new StringBuilder();
                    for (Object obj : c1.getValues()) {
                        comparisonName.append(Formatter.toString(obj));
                        comparisonName.append(" ");
                    }
                    comparisonName.append("vs.");
                    for (Object obj : c2.getValues()) {
                        comparisonName.append(" ");
                        comparisonName.append(Formatter.toString(obj));
                    }
                    if (matchValues != null) {
                        comparisonName.append(" (");
                        for (int k = 0; k < matchValues.size(); ++k) {
                            Object obj;
                            obj = matchValues.get(k);
                            if (k > 0) {
                                comparisonName.append(" ");
                            }
                            comparisonName.append(Formatter.toString(obj));
                        }
                        comparisonName.append(")");
                    }
                    if (classOneColumnIndices.size() <= 0 || classTwoColumnIndices.size() <= 0) continue;
                    TwoClassComparison c = new TwoClassComparison(comparisonName.toString(), (Set<Integer>)classOneColumnIndices, (Set<Integer>)classTwoColumnIndices);
                    comparisons.add(c);
                }
            }
        }
        return comparisons.toArray(new TwoClassComparison[0]);
    }

    public void init(Project project) {
        this.project = project;
        MetadataModel metadata = project.getOriginalDataset().getColumnMetadata();
        Object[] savedGroupBySelection = this.groupComparisonsByCheckBoxList.getSelectedObjects();
        DefaultComboBoxModel<String> groupByFieldModel = new DefaultComboBoxModel<String>();
        int metadataSize = metadata.getMetadataCount();
        for (int i = 0; i < metadataSize; ++i) {
            Vector vector = metadata.get(i);
            groupByFieldModel.addElement(vector.getName());
        }
        this.groupComparisonsByCheckBoxList.setModel(groupByFieldModel);
        this.groupComparisonsByCheckBoxList.setSelectedObjects(savedGroupBySelection);
        this.setProject(project);
        this.firstTime = false;
    }

    protected List<Combination> createCombinations(Dataset dataset, List<Combination> combinations, List<String> selectedMetadataNames, boolean intersection, boolean classA) {
        LinkedHashSet<Integer> resultIndices = new LinkedHashSet<Integer>();
        int size = combinations.size();
        for (int i = 0; i < size; ++i) {
            Combination c = combinations.get(i);
            Set<Integer> indices = c.getIndices();
            if (!intersection) {
                resultIndices.addAll(indices);
                continue;
            }
            if (i == 0) {
                resultIndices.addAll(indices);
                continue;
            }
            resultIndices.retainAll(indices);
        }
        int[] metadataIndices = MetadataUtil.getIndices(dataset.getColumnMetadata(), selectedMetadataNames, true);
        Set[] valuesForEachField = new Set[metadataIndices.length];
        int nfields = valuesForEachField.length;
        for (int i = 0; i < nfields; ++i) {
            valuesForEachField[i] = new LinkedHashSet();
        }
        Iterator i$ = resultIndices.iterator();
        while (i$.hasNext()) {
            int datasetColumnIndex = (Integer)i$.next();
            int nfields2 = valuesForEachField.length;
            for (int i = 0; i < nfields2; ++i) {
                valuesForEachField[i].add(dataset.getColumnMetadata().get(metadataIndices[i]).getValue(datasetColumnIndex));
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        int nfields3 = valuesForEachField.length;
        for (int i = 0; i < nfields3; ++i) {
            values.add(valuesForEachField[i]);
        }
        return Arrays.asList(new Combination(values, resultIndices));
    }

    protected Dataset getDataset() {
        return this.inModelSpace ? this.project.getOriginalDataset() : this.project.getSortedFilteredDataset();
    }

    protected abstract List<Combination>[] getSelectedCombinations();

    protected abstract void setProject(Project var1);

    protected static List<Combination> getSelectedClassCombinations(JList list, MetadataModel metadata) {
        Object[] selectedClassOneItems = list instanceof CheckBoxList ? ((CheckBoxList)list).getCheckBoxListSelectedValues() : list.getSelectedValues();
        ArrayList<Combination> classOneCombinations = new ArrayList<Combination>();
        for (Object combination : selectedClassOneItems) {
            classOneCombinations.add((Combination)combination);
        }
        return classOneCombinations;
    }
}

