/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import org.broadinstitute.genee.gui.ProgressDialog;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;

public abstract class BackgroundTask<T>
extends SwingWorker<T, Void>
implements ProgressNotifier {
    private String title;
    private ProgressDialog dialog;

    protected BackgroundTask(String title) {
        this.title = title;
        if (!GraphicsEnvironment.isHeadless()) {
            this.dialog = new ProgressDialog(title, false);
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BackgroundTask.this.dialog.dispose();
                    BackgroundTask.this.cancel(true);
                }
            };
            this.dialog.addStopActionListener(l);
            this.dialog.setVisible(true);
        }
    }

    @Override
    public void setMessage(String message) {
        if (this.dialog != null) {
            this.dialog.setMessage(message);
        }
    }

    public void setTitle(String title) {
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }

    @Override
    public void setPercentComplete(float progress) {
        if (this.dialog != null) {
            this.dialog.setPercentComplete(progress);
        }
    }

    protected void cancelled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void done() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        try {
            if (this.isCancelled()) {
                this.cancelled();
            } else {
                try {
                    this.succeeded(this.get());
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    this.failed(e.getCause());
                }
            }
        }
        finally {
            this.finished();
        }
    }

    protected void failed(Throwable cause) {
        String message;
        String text;
        cause.printStackTrace();
        Throwable error = null;
        String string = text = cause instanceof OutOfMemoryError || cause.getCause() instanceof OutOfMemoryError ? "Not enough memory available." : cause.getMessage();
        if (cause instanceof HDF5Exception && (message = cause.getMessage()) != null && message.startsWith("Out Of Memory")) {
            text = "Not enough memory available.";
        }
        if (text == null || text.equals("")) {
            text = "An unexpected error occurred.";
            error = cause;
        }
        if (this.dialog != null) {
            UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), text, this.title, error);
            this.dialog.dispose();
        }
    }

    protected void finished() {
    }

    protected void succeeded(T result) {
    }
}

