/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.hints.ListDataIntelliHints;
import com.jidesoft.swing.CheckBoxList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.clustering.hierarchical.AbstractDendrogramPanel;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.QuickListFilter;
import org.broadinstitute.genee.heatmap.menu.DefaultNodeColorScheme;
import org.broadinstitute.genee.heatmap.menu.NodeScoreCalculator;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class DendrogramOptionsPanel
extends JPanel {
    private JComboBox colorByComboBox;
    private JLabel colorByLabel;
    private JCheckBox colorDendrogramCheckBox;
    private JComboBox colorSelectorComboBox;
    private AbstractDendrogramPanel dendrogramPanel;
    private JCheckBox drawNodePieChartCheckBox;
    private HeatMapPanel heatMapPanel;
    private TimerTextField minCategoryMembersTextField;
    private TimerTextField minPValueTextField;
    private TimerTextField minSetSize;
    private JPanel nodeColorPanel;
    private TimerTextField nodeHeightTextField;
    private ActionListener nodeRadiusListener;
    private PieChartElementsSelector pieChartElementsSelector;
    private FormBuilder pieChartFormBuilder;
    private boolean row;
    private JPanel scoreColorPanel;
    private JCheckBox scoreDynamicallyCheckBox;
    private FormBuilder scoreDynamicallyForm;
    private int minClusterMembers = 5;
    private int minClusterMembersForCategory = 2;
    private float minPValue = 0.05f;
    private float maxNodeCorrelation = 1.0f;
    public List<String> completionList = Collections.emptyList();

    public DendrogramOptionsPanel(HeatMapPanel heatMapPanel, boolean row) {
        this.heatMapPanel = heatMapPanel;
        this.row = row;
        this.dendrogramPanel = row ? heatMapPanel.getRowDendrogramPanel() : heatMapPanel.getColumnDendrogramPanel();
        FormBuilder formBuilder = new FormBuilder(this);
        formBuilder.nextRow();
        this.scoreDynamicallyCheckBox = new JCheckBox("Compute p-value using hypergeometric test", this.dendrogramPanel.getNodeScoreSource().equals((Object)AbstractDendrogramPanel.NodeScoreSource.NODE_SCORE_SOURCE_DYNAMIC));
        this.scoreDynamicallyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DendrogramOptionsPanel.this.scoreDynamicallyForm.getPanel().setEnabled(DendrogramOptionsPanel.this.scoreDynamicallyCheckBox.isSelected());
                UIUtil.setChildrenEnabledRecursively(DendrogramOptionsPanel.this.scoreDynamicallyForm.getPanel(), DendrogramOptionsPanel.this.scoreDynamicallyCheckBox.isSelected());
                DendrogramOptionsPanel.this.dendrogramPanel.setNodeScoreSource(DendrogramOptionsPanel.this.scoreDynamicallyCheckBox.isSelected() ? AbstractDendrogramPanel.NodeScoreSource.NODE_SCORE_SOURCE_DYNAMIC : AbstractDendrogramPanel.NodeScoreSource.NODE_SCORE_SOURCE_STATIC);
                DendrogramOptionsPanel.this.updateEnabled();
                DendrogramOptionsPanel.this.updateColorSchemeEnabled();
            }
        });
        formBuilder.addSpanned(this.scoreDynamicallyCheckBox);
        this.scoreDynamicallyForm = new FormBuilder();
        this.scoreDynamicallyForm.nextRow();
        this.scoreDynamicallyForm.addLabel("Minimum number of total members in set:");
        this.minSetSize = new TimerTextField("5"){

            @Override
            public void update() {
                try {
                    DendrogramOptionsPanel.this.minClusterMembers = ParserHelper.parseInt(this.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    DendrogramOptionsPanel.this.minClusterMembers = -1;
                }
                DendrogramOptionsPanel.this.updateNodeColorPValues();
                DendrogramOptionsPanel.this.updatePieChartPValues();
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        };
        this.scoreDynamicallyForm.add(this.minSetSize);
        this.scoreDynamicallyForm.nextRow();
        this.scoreDynamicallyForm.addLabel("Minimum number of members in set:");
        this.minCategoryMembersTextField = new TimerTextField("3"){

            @Override
            public void update() {
                try {
                    DendrogramOptionsPanel.this.minClusterMembersForCategory = ParserHelper.parseInt(this.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    DendrogramOptionsPanel.this.minClusterMembersForCategory = -1;
                }
                DendrogramOptionsPanel.this.updateNodeColorPValues();
                DendrogramOptionsPanel.this.updatePieChartPValues();
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        };
        this.scoreDynamicallyForm.add(this.minCategoryMembersTextField);
        this.scoreDynamicallyForm.nextRow();
        this.scoreDynamicallyForm.addLabel("p-value to stop testing dendrogram branch:");
        this.minPValueTextField = new TimerTextField("0.05"){

            @Override
            public void update() {
                try {
                    DendrogramOptionsPanel.this.minPValue = ParserHelper.parseFloat(this.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    DendrogramOptionsPanel.this.minPValue = 0.0f;
                }
                DendrogramOptionsPanel.this.updateNodeColorPValues();
                DendrogramOptionsPanel.this.updatePieChartPValues();
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        };
        this.scoreDynamicallyForm.add(this.minPValueTextField);
        this.scoreDynamicallyForm.nextRow();
        this.scoreDynamicallyForm.addLabel("Node height to stop testing dendrogram:");
        this.nodeHeightTextField = new TimerTextField(""){

            @Override
            public void update() {
                try {
                    DendrogramOptionsPanel.this.maxNodeCorrelation = ParserHelper.parseFloat(this.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    DendrogramOptionsPanel.this.maxNodeCorrelation = 1.0f;
                }
                DendrogramOptionsPanel.this.updateNodeColorPValues();
                DendrogramOptionsPanel.this.updatePieChartPValues();
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        };
        this.scoreDynamicallyForm.add(this.nodeHeightTextField);
        this.scoreDynamicallyForm.setIndentedBorder();
        formBuilder.nextRow().addSpanned(this.scoreDynamicallyForm.getPanel());
        this.drawNodePieChartCheckBox = new JCheckBox("Draw pie chart at node", this.dendrogramPanel != null ? this.dendrogramPanel.isDrawPieChart() : false);
        this.colorDendrogramCheckBox = new JCheckBox("Color dendrogram", this.dendrogramPanel != null ? this.dendrogramPanel.isColorNodes() : false);
        this.colorByComboBox = UIUtil.createComboBox();
        this.colorByComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DendrogramOptionsPanel.this.updateNodeColorPValues();
            }
        });
        this.colorSelectorComboBox = UIUtil.createComboBox();
        final EditColorButton editColorButton = new EditColorButton(Color.DARK_GRAY);
        editColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DendrogramOptionsPanel.this.dendrogramPanel.setPieChartColor(DendrogramOptionsPanel.this.scoreDynamicallyCheckBox.isSelected(), String.valueOf(DendrogramOptionsPanel.this.colorSelectorComboBox.getSelectedItem()), editColorButton.getColor());
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        });
        this.colorSelectorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = String.valueOf(DendrogramOptionsPanel.this.colorSelectorComboBox.getSelectedItem());
                Color color = DendrogramOptionsPanel.this.dendrogramPanel.getPieChartColor(DendrogramOptionsPanel.this.scoreDynamicallyCheckBox.isSelected(), name);
                editColorButton.setColor(color != null ? color : Color.BLACK);
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        });
        this.scoreColorPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(2), "p"));
        CellConstraints cc = new CellConstraints();
        this.scoreColorPanel.add((Component)this.colorSelectorComboBox, cc.xy(1, 1));
        this.scoreColorPanel.add((Component)editColorButton, cc.xy(3, 1));
        if (this.colorSelectorComboBox.getItemCount() > 0) {
            this.colorSelectorComboBox.setSelectedIndex(0);
        }
        formBuilder.nextRow();
        formBuilder.addSpanned(this.drawNodePieChartCheckBox);
        formBuilder.nextRow();
        this.pieChartFormBuilder = new FormBuilder();
        this.pieChartFormBuilder.setIndentedBorder().nextRow();
        final JCheckBox negLog2CheckBox = new JCheckBox("Negative log 2", true);
        negLog2CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DendrogramOptionsPanel.this.dendrogramPanel.setNegativeLog2(negLog2CheckBox.isSelected());
            }
        });
        this.pieChartFormBuilder.addSpanned(negLog2CheckBox);
        this.pieChartFormBuilder.nextRow();
        this.pieChartFormBuilder.addLabel("Elements:");
        JButton editElementsButton = new JButton("Edit\u2026");
        this.pieChartElementsSelector = new PieChartElementsSelector();
        editElementsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DendrogramOptionsPanel.this.pieChartElementsSelector.show();
            }
        });
        this.pieChartFormBuilder.add(editElementsButton);
        this.pieChartFormBuilder.nextRow();
        this.pieChartFormBuilder.addLabel("Color:");
        this.pieChartFormBuilder.add(this.scoreColorPanel);
        this.pieChartFormBuilder.nextRow();
        this.pieChartFormBuilder.addLabel("Minimum diameter:");
        TimerTextField minNodeRadiusTextField = new TimerTextField("6"){

            @Override
            public void update() {
                String text = this.getText();
                if (text != null && !"".equals(text)) {
                    float minNodeSize = ParserHelper.parseFloat(text);
                    DendrogramOptionsPanel.this.dendrogramPanel.setMinDiameter(minNodeSize);
                    DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
                }
            }
        };
        this.pieChartFormBuilder.add(minNodeRadiusTextField);
        this.pieChartFormBuilder.nextRow();
        this.pieChartFormBuilder.addLabel("Maximum diameter:");
        TimerTextField maxNodeRadiusTextField = new TimerTextField("20"){

            @Override
            public void update() {
                String text = this.getText();
                if (text != null && !"".equals(text)) {
                    float maxNodeSize = ParserHelper.parseFloat(text);
                    DendrogramOptionsPanel.this.dendrogramPanel.setMaxDiameter(maxNodeSize);
                    DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
                }
            }
        };
        this.pieChartFormBuilder.add(maxNodeRadiusTextField);
        formBuilder.addSpanned(this.pieChartFormBuilder.getPanel());
        formBuilder.nextRow();
        formBuilder.addSpanned(this.colorDendrogramCheckBox);
        formBuilder.nextSmallRow();
        FormBuilder colorByFormBuilder = new FormBuilder();
        this.colorByLabel = colorByFormBuilder.nextRow().setIndentedBorder().addLabel("By:");
        colorByFormBuilder.add(this.colorByComboBox);
        formBuilder.addSpanned(colorByFormBuilder.getPanel());
        formBuilder.nextRow();
        final EditColorButton nodeColorButton = new EditColorButton(Color.BLUE);
        nodeColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DefaultNodeColorScheme)DendrogramOptionsPanel.this.dendrogramPanel.getNodeColorScheme()).setColor(nodeColorButton.getColor());
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        });
        final JComboBox nodeScoreComparisonComboBox = UIUtil.createComboBox(new Object[]{">", "<", ">=", "<="});
        nodeScoreComparisonComboBox.setSelectedIndex(3);
        nodeScoreComparisonComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DefaultNodeColorScheme)DendrogramOptionsPanel.this.dendrogramPanel.getNodeColorScheme()).setComparison(nodeScoreComparisonComboBox.getSelectedIndex());
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        });
        TimerTextField nodeScoreTextField = new TimerTextField("0.05"){

            @Override
            public void update() {
                try {
                    ((DefaultNodeColorScheme)DendrogramOptionsPanel.this.dendrogramPanel.getNodeColorScheme()).setScore(ParserHelper.parseFloat(this.getText().trim()));
                    DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.nodeColorPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(5), "p"));
        this.nodeColorPanel.add((Component)new JLabel("Color"), cc.xy(1, 1));
        this.nodeColorPanel.add((Component)nodeColorButton, cc.xy(3, 1));
        this.nodeColorPanel.add((Component)new JLabel("if significance"), cc.xy(5, 1));
        this.nodeColorPanel.add((Component)nodeScoreComparisonComboBox, cc.xy(7, 1));
        this.nodeColorPanel.add((Component)nodeScoreTextField, cc.xy(9, 1));
        this.nodeColorPanel.setBorder(FormBuilder.createIndentedBorder(1));
        formBuilder.addSpanned(this.nodeColorPanel);
        this.nodeRadiusListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DendrogramOptionsPanel.this.drawNodePieChartCheckBox) {
                    DendrogramOptionsPanel.this.dendrogramPanel.setDrawPieChart(DendrogramOptionsPanel.this.drawNodePieChartCheckBox.isSelected());
                }
                DendrogramOptionsPanel.this.updateEnabled();
            }
        };
        this.colorDendrogramCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DendrogramOptionsPanel.this.updateNodeColorPValues();
                DendrogramOptionsPanel.this.updateColorSchemeEnabled();
                DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
            }
        });
        this.drawNodePieChartCheckBox.addActionListener(this.nodeRadiusListener);
        this.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 0));
        this.updateEnabled();
        this.updateColorSchemeEnabled();
    }

    private void updateNodeColorPValues() {
        if (!this.colorDendrogramCheckBox.isSelected() || !this.colorDendrogramCheckBox.isEnabled()) {
            return;
        }
        int index = this.colorByComboBox.getSelectedIndex();
        if (this.scoreDynamicallyCheckBox.isSelected()) {
            if (index != -1) {
                MetadataModel metadata = this.row ? this.heatMapPanel.getProject().getOriginalDataset().getRowMetadata() : this.heatMapPanel.getProject().getOriginalDataset().getColumnMetadata();
                Vector[] categoryGroups = new Vector[]{metadata.get(index)};
                final HashMap<String, Float> nodeIdToScore = new HashMap<String, Float>();
                NodeScoreCalculator.NodeScoreSetter nodeScoreSetter = new NodeScoreCalculator.NodeScoreSetter(){

                    @Override
                    public void setScore(Node node, float[] scores) {
                        nodeIdToScore.put(node.getId(), Float.valueOf(scores[0]));
                    }
                };
                this.getPValuesForCategories(categoryGroups, nodeScoreSetter);
                this.dendrogramPanel.getNodeColorScheme().update(nodeIdToScore);
            }
        } else {
            this.dendrogramPanel.getNodeColorScheme().update(this.dendrogramPanel.getNodeIdToScore(this.scoreDynamicallyCheckBox.isSelected()), index);
        }
        this.dendrogramPanel.repaintImage();
    }

    private void updateColorSchemeEnabled() {
        this.nodeColorPanel.setEnabled(this.colorDendrogramCheckBox.isSelected());
        this.dendrogramPanel.setColorNodes(this.colorDendrogramCheckBox.isSelected());
        this.colorByComboBox.setEnabled(this.nodeColorPanel.isEnabled());
        this.colorByLabel.setEnabled(this.nodeColorPanel.isEnabled());
    }

    private void updateEnabled() {
        UIUtil.setChildrenEnabledRecursively(this, this.dendrogramPanel.getNodeScoreNames(this.scoreDynamicallyCheckBox.isSelected()) != null || this.scoreDynamicallyCheckBox.isSelected());
        boolean enabledRadius = this.drawNodePieChartCheckBox.isSelected();
        this.updateScoreChoices();
        UIUtil.setChildrenEnabledRecursively(this.pieChartFormBuilder.getPanel(), enabledRadius);
        UIUtil.setChildrenEnabledRecursively(this.scoreColorPanel, enabledRadius);
        this.scoreDynamicallyCheckBox.setEnabled(true);
        this.colorByComboBox.setEnabled(this.colorDendrogramCheckBox.isSelected());
        this.dendrogramPanel.repaintImage();
    }

    private void updatePieChartPValues() {
        int[] selected = this.pieChartElementsSelector.checkBoxList.getCheckBoxListSelectedIndices();
        if (this.scoreDynamicallyCheckBox.isSelected()) {
            if (selected == null || selected.length == 0) {
                this.dendrogramPanel.setNodeIdToScores(true, null);
                this.dendrogramPanel.setNodeScoreNames(true, null);
                return;
            }
            String[] names = new String[selected.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = String.valueOf(this.pieChartElementsSelector.listModel.getElementAt(selected[i]));
            }
            MetadataModel metadata = this.row ? this.heatMapPanel.getProject().getOriginalDataset().getRowMetadata() : this.heatMapPanel.getProject().getOriginalDataset().getColumnMetadata();
            Vector[] categoryGroups = new Vector[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                categoryGroups[i] = metadata.get(selected[i]);
            }
            final HashMap<String, float[]> nodeIdToScores = new HashMap<String, float[]>();
            NodeScoreCalculator.NodeScoreSetter nodeScoreSetter = new NodeScoreCalculator.NodeScoreSetter(){

                @Override
                public void setScore(Node node, float[] scores) {
                    nodeIdToScores.put(node.getId(), scores);
                }
            };
            this.getPValuesForCategories(categoryGroups, nodeScoreSetter);
            this.dendrogramPanel.setNodeIdToScores(true, nodeIdToScores);
            this.dendrogramPanel.setNodeScoreNames(true, names);
        } else {
            this.dendrogramPanel.setPieChartColumnIndices(this.scoreDynamicallyCheckBox.isSelected(), selected);
        }
    }

    private void getPValuesForCategories(Vector[] categoryGroups, NodeScoreCalculator.NodeScoreSetter nodeScoreSetter) {
        NodeScoreCalculator n = new NodeScoreCalculator(this.minClusterMembers, this.minClusterMembersForCategory, this.minPValue, this.maxNodeCorrelation);
        Dataset dataset = this.heatMapPanel.getProject().getOriginalDataset();
        if (!this.row) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        n.setNodePValues(this.row ? this.heatMapPanel.getProject().getRowDendrogram() : this.heatMapPanel.getProject().getColumnDendrogram(), dataset, categoryGroups, nodeScoreSetter);
    }

    private void updateScoreChoices() {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.scoreDynamicallyCheckBox.isSelected()) {
            MetadataModel metadata = this.row ? this.heatMapPanel.getProject().getOriginalDataset().getRowMetadata() : this.heatMapPanel.getProject().getOriginalDataset().getColumnMetadata();
            int size = metadata.getMetadataCount();
            for (int i = 0; i < size; ++i) {
                elements.add(metadata.get(i));
            }
        } else {
            String[] names = this.dendrogramPanel.getNodeScoreNames(this.scoreDynamicallyCheckBox.isSelected());
            if (names != null) {
                for (String name : names) {
                    elements.add(name);
                }
            }
        }
        UIUtil.setElements(this.colorByComboBox, elements);
        UIUtil.setElements(this.colorSelectorComboBox, elements);
        this.pieChartElementsSelector.setElements(elements);
    }

    private class PieChartElementsSelector {
        private CheckBoxList checkBoxList;
        private FilterableListModel listModel;
        private ListDataIntelliHints<String> textFieldHints;
        private GENEEWindow window;

        public PieChartElementsSelector() {
            this.window = Application.createDialog(DendrogramOptionsPanel.this, "Choose Elements");
            this.listModel = new FilterableListModel();
            JPanel quickSearchPanel = new JPanel(new FlowLayout(3));
            this.checkBoxList = new CheckBoxList((ListModel)((Object)this.listModel));
            QuickListFilter filterField = new QuickListFilter((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), this.listModel){

                @Override
                protected String getSavedSearchKey() {
                    return null;
                }
            };
            quickSearchPanel.add((Component)((Object)filterField));
            this.textFieldHints = new DelimListDataIntelliHints(filterField.getTextField()){

                @Override
                public Collection<String> getMatches(String text) {
                    ArrayList<String> matches = new ArrayList<String>();
                    boolean caseSensitive = this.isCaseSensitive();
                    Iterator<String> i$ = DendrogramOptionsPanel.this.completionList.iterator();
                    while (i$.hasNext()) {
                        String id;
                        String _id = id = i$.next();
                        if (!caseSensitive) {
                            _id = _id.toLowerCase();
                        }
                        if (!_id.startsWith(text)) continue;
                        matches.add(id);
                    }
                    Collections.sort(matches, String.CASE_INSENSITIVE_ORDER);
                    return matches;
                }
            };
            this.checkBoxList.getCheckBoxListSelectionModel().addSelectionInterval(0, this.checkBoxList.getModel().getSize() - 1);
            JScrollPane sp = new JScrollPane((Component)this.checkBoxList);
            JPanel topPanel = new JPanel((LayoutManager)new FormLayout("pref", "pref, pref"));
            CellConstraints cc = new CellConstraints();
            topPanel.add((Component)quickSearchPanel, cc.xy(1, 1));
            Dimension size = this.checkBoxList.getPreferredSize();
            size.width = topPanel.getPreferredSize().width;
            this.checkBoxList.setPreferredSize(size);
            sp.setColumnHeaderView(topPanel);
            this.window.getContentPane().add(sp);
            this.window.getContentPane().add((Component)UIUtil.buildOKCancelBar(this.window, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DendrogramOptionsPanel.this.updatePieChartPValues();
                    if (DendrogramOptionsPanel.this.colorSelectorComboBox.getItemCount() > 0) {
                        DendrogramOptionsPanel.this.colorSelectorComboBox.setSelectedIndex(0);
                    }
                    DendrogramOptionsPanel.this.dendrogramPanel.repaintImage();
                    PieChartElementsSelector.this.window.setVisible(false);
                }
            }), "South");
            this.window.pack();
            this.window.setSize(Math.max(300, this.window.getWidth()), Math.max(400, this.window.getHeight()));
        }

        public void setElements(List<Object> elements) {
            this.listModel.removeAllElements();
            TreeSet<String> set = new TreeSet<String>();
            if (elements != null) {
                for (Object obj : elements) {
                    this.listModel.addElement(obj);
                    set.add(String.valueOf(obj));
                }
            }
            DendrogramOptionsPanel.this.completionList = new ArrayList<String>(set);
        }

        public void show() {
            this.window.setVisible(true);
        }
    }
}

