/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class DetachedMagnifyingGlass
extends JComponent
implements MouseMotionListener {
    float zoom;
    Point point = new Point(-1, -1);
    Robot robot;

    public DetachedMagnifyingGlass(JComponent[] comps, float zoom) {
        for (JComponent comp : comps) {
            comp.addMouseMotionListener(this);
        }
        this.zoom = zoom;
        try {
            this.robot = new Robot();
        }
        catch (AWTException awte) {
            System.err.println("Can't get a Robot");
            awte.printStackTrace();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point offsetPoint = ((Component)e.getSource()).getLocationOnScreen();
        e.translatePoint(offsetPoint.x, offsetPoint.y);
        this.point = e.getPoint();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.robot == null || this.point.x == -1) {
            g.setColor(Color.blue);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            return;
        }
        Rectangle grabRect = this.computeGrabRect();
        BufferedImage grabImg = this.robot.createScreenCapture(grabRect);
        Image scaleImg = grabImg.getScaledInstance(this.getSize().width, this.getSize().height, 2);
        g.drawImage(scaleImg, 0, 0, null);
    }

    private Rectangle computeGrabRect() {
        int grabWidth = (int)((float)this.getSize().width / this.zoom);
        int grabHeight = (int)((float)this.getSize().height / this.zoom);
        return new Rectangle(this.point.x, this.point.y, grabWidth, grabHeight);
    }
}

