/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

class DiscreteColorEditorPanel
extends JPanel {
    public DiscreteColorEditorPanel(final Vector vector, final VectorColorModel colorModel) {
        Set values = VectorUtil.getValues(vector);
        this.setLayout((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout(2), UIUtil.createRowStringForFormLayout(values.size())));
        CellConstraints cc = new CellConstraints();
        int rowIndex = 1;
        for (final Object val : values) {
            final EditColorButton editColorBtn = new EditColorButton((Color)colorModel.getMappedValue(vector, val));
            this.add((Component)new JLabel(Formatter.toString(val)), cc.xy(1, rowIndex));
            this.add((Component)editColorBtn, cc.xy(3, rowIndex));
            editColorBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    colorModel.setMappedValue(vector, val, editColorBtn.getColor());
                }
            });
            rowIndex += 2;
        }
        this.revalidate();
        this.repaint();
    }
}

