/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.Drawable;

public class DrawableWrapper
implements Drawable {
    private boolean forcePrintAtPreferredSize;
    protected Component c;
    private Color backgroundColor;
    private Dimension drawableSizeSpecified;

    public DrawableWrapper(Component c) {
        this(c, false);
    }

    public DrawableWrapper(Component c, boolean forcePrintAtPreferredSize) {
        this(c, forcePrintAtPreferredSize, Color.WHITE);
    }

    public DrawableWrapper(Component c, boolean forcePrintAtPreferredSize, Color backgroundColor) {
        if (c == null) {
            throw new NullPointerException("Component is null.");
        }
        this.c = c;
        this.backgroundColor = backgroundColor;
        this.forcePrintAtPreferredSize = forcePrintAtPreferredSize;
    }

    public DrawableWrapper copy() {
        DrawableWrapper wrapper = new DrawableWrapper(this.c, this.forcePrintAtPreferredSize);
        wrapper.drawableSizeSpecified = this.drawableSizeSpecified;
        wrapper.backgroundColor = this.backgroundColor;
        return wrapper;
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        this.beforeDraw(g, clip);
        Color savedBackground = null;
        if (this.backgroundColor != null) {
            savedBackground = this.c.getBackground();
        }
        this.c.setBackground(this.backgroundColor);
        Shape savedClip = g.getClip();
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform savedTransform = g2.getTransform();
        if (clip != null) {
            g2.translate(-clip.x, -clip.y);
            g2.setClip(clip);
        }
        if (this.c instanceof Drawable) {
            ((Drawable)((Object)this.c)).draw(g, clip);
        } else {
            DrawableWrapper.print(this.c, g, this.forcePrintAtPreferredSize);
        }
        g.setClip(savedClip);
        g2.setTransform(savedTransform);
        if (this.backgroundColor != null) {
            this.c.setBackground(savedBackground);
        }
        this.afterDraw(g, clip);
    }

    public Drawable getDrawable() {
        return this;
    }

    @Override
    public Dimension getDrawableSize() {
        if (this.drawableSizeSpecified != null) {
            return this.drawableSizeSpecified;
        }
        return this.c instanceof Drawable ? ((Drawable)((Object)this.c)).getDrawableSize() : this.c.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.c.getPreferredSize();
    }

    public void setComponent(JComponent c) {
        this.c = c;
    }

    public void setDrawableSizeSpecified(Dimension drawableSizeSpecified) {
        this.drawableSizeSpecified = drawableSizeSpecified;
    }

    public void setPreferredSize(Dimension size) {
        this.c.setPreferredSize(size);
    }

    protected void afterDraw(Graphics g, Rectangle clip) {
    }

    protected void beforeDraw(Graphics g, Rectangle clip) {
    }

    public static void setPropsToPrint(Component c, Dimension prefSize) {
        DrawableWrapper.setPropsToPrint(c, prefSize, null);
    }

    public static void setPropsToPrint(Component c, Dimension prefSize, Rectangle clip) {
        Rectangle bounds;
        clip = null;
        Rectangle rectangle = bounds = clip == null ? new Rectangle(prefSize) : new Rectangle(clip.width, clip.height);
        if (c.isShowing()) {
            c.setSize(prefSize);
            c.setBounds(bounds);
        } else {
            c.setBounds(bounds);
            c.addNotify();
            c.setVisible(true);
        }
        c.invalidate();
        c.validate();
    }

    private static void print(Component c, Graphics g, boolean forcePrintAtPreferredSize) {
        if (c.getParent() == null || !c.isShowing()) {
            JPanel panel = new JPanel();
            Dimension oldSize = c.getSize();
            DrawableWrapper.setPropsToPrint(c, c.getPreferredSize());
            panel.add(c);
            c.print(g);
            c.setSize(oldSize);
            panel.remove(c);
        } else {
            c.print(g);
        }
    }
}

