/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.enterprisedt.net.ftp.FTPException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.broadinstitute.genee.gui.FTPFile;
import org.broadinstitute.genee.gui.FTPFileModel;

public class FTPList
extends JList {
    private FTPFileModel model;

    public FTPList(FTPFileModel model) {
        this.model = model;
        DefaultListModel<String> tmp = new DefaultListModel<String>();
        tmp.addElement("Connecting to FTP site\u2026");
        this.setModel(tmp);
    }

    public FTPList(String host, String dir, String username, String password) {
        this.setSelectionMode(2);
        try {
            this.model = new FTPFileModel(host, dir, username, password);
            DefaultListModel<String> tmp = new DefaultListModel<String>();
            tmp.addElement("Connecting to FTP site\u2026");
            this.setModel(tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            DefaultListModel<String> listModel = new DefaultListModel<String>();
            listModel.addElement("Unable to connect to FTP site");
            this.setModel(listModel);
        }
    }

    public void downloadFile(FTPFile file, OutputStream os) throws FTPException, IOException {
        this.model.downloadFile(os, file.getName());
    }

    public File[] downloadFiles(FTPFile[] values, File destinationDirectory) throws Exception {
        File[] files;
        if (values != null) {
            files = new File[values.length];
            for (int i = 0; i < values.length; ++i) {
                File dest;
                FTPFile f = values[i];
                String selectedFilename = f.getName();
                files[i] = dest = new File(destinationDirectory, selectedFilename);
                this.model.downloadFile(dest, selectedFilename);
            }
        } else {
            files = new File[]{};
        }
        return files;
    }

    public void downloadSelectedItem(File dest) throws Exception {
        String selectedFilename = ((FTPFile)this.getSelectedValue()).getName();
        this.model.downloadFile(dest, selectedFilename);
    }

    public String[] getFileNames() {
        return this.model.getFileNames();
    }

    public void quit() throws IOException, FTPException {
        this.model.quit();
    }

    public void connect() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        String[] filenames = this.model.getFileNames();
        try {
            if (filenames != null) {
                int length = filenames.length;
                for (int i = 0; i < length; ++i) {
                    listModel.addElement(new FTPFile(this.model.getHost(), this.model.getDir(), filenames[i]));
                }
            }
            this.setModel(listModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            listModel.clear();
            listModel.addElement("Unable to connect to FTP site");
        }
    }
}

