/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.SearchableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.heatmap.QuickListFilter;

public class FilterListPanel
extends JPanel {
    private CheckBoxList rowSpaceList;
    private FilterableListModel rowSpaceModel;

    public FilterListPanel(Comparator c) {
        this(null, c);
    }

    public FilterListPanel(Object[] values, Comparator c) {
        if (values != null) {
            Arrays.sort(values, c);
        }
        this.rowSpaceModel = new FilterableListModel();
        if (values != null) {
            for (Object value : values) {
                this.rowSpaceModel.addElement(value);
            }
        }
        JPanel quickSearchPanel = new JPanel(new FlowLayout(3));
        this.rowSpaceList = new CheckBoxList((ListModel)((Object)this.rowSpaceModel)){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 250;
                return size;
            }
        };
        QuickListFilter filterField = new QuickListFilter((ListSelectionModel)this.rowSpaceList.getCheckBoxListSelectionModel(), this.rowSpaceModel){

            @Override
            protected String getSavedSearchKey() {
                return null;
            }
        };
        quickSearchPanel.add((Component)((Object)filterField));
        this.rowSpaceList.getCheckBoxListSelectionModel().addSelectionInterval(0, this.rowSpaceList.getModel().getSize() - 1);
        SearchableUtils.installSearchable((JList)this.rowSpaceList);
        JPanel selectPanel = new JPanel();
        JButton selectAll = new JButton("All");
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterListPanel.this.rowSpaceList.getCheckBoxListSelectionModel().addSelectionInterval(0, FilterListPanel.this.rowSpaceList.getModel().getSize() - 1);
            }
        });
        this.rowSpaceList.setVisibleRowCount(10);
        selectPanel.add(selectAll);
        JButton selectNone = new JButton("None");
        selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterListPanel.this.rowSpaceList.getCheckBoxListSelectionModel().clearSelection();
            }
        });
        selectPanel.add(selectNone);
        JScrollPane sp = new JScrollPane((Component)this.rowSpaceList, 22, 30);
        JPanel topPanel = new JPanel((LayoutManager)new FormLayout("pref:g", "pref:g, pref:g"));
        CellConstraints cc = new CellConstraints();
        topPanel.add((Component)quickSearchPanel, cc.xy(1, 1));
        topPanel.add((Component)selectPanel, cc.xy(1, 2));
        sp.setColumnHeaderView(topPanel);
        this.setLayout(new BorderLayout());
        this.add(sp);
    }

    public void addElement(Object value) {
        this.rowSpaceModel.addElement(value);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.rowSpaceList.getCheckBoxListSelectionModel().addListSelectionListener(l);
    }

    public Object[] getCheckBoxListSelectedValues() {
        return this.rowSpaceList.getCheckBoxListSelectedValues();
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.rowSpaceList.getCheckBoxListSelectionModel().removeListSelectionListener(l);
    }
}

