/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.broadinstitute.genee.gui.GelModel;
import org.broadinstitute.genee.gui.GelModelAdapter;
import org.broadinstitute.genee.gui.GelView;
import org.broadinstitute.genee.gui.InterpolatedGelModel;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;
import org.jdesktop.swingx.HorizontalLayout;

public class GelController {
    private JPanel panel;
    private GelModel thetaRankSupplier;
    private MouseAdapter mouseListener;
    private List<GelView> views = new ArrayList<GelView>();
    private Animator animator;
    private GelView selectedView;
    private int selectedIndex;
    private boolean useDistances = true;

    public GelController() {
        this.panel = new JPanel((LayoutManager)new HorizontalLayout(20)){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
            }
        };
        this.panel.setBackground(Color.WHITE);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction("Set as reference"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GelController.this.changeReference(GelController.this.selectedView.getModel());
            }
        });
        final AbstractAction setRefIndexAction = new AbstractAction("Set reference instance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GelController.this.changeIndex(GelController.this.selectedIndex);
            }
        };
        popupMenu.add(setRefIndexAction);
        final JCheckBoxMenuItem useDistanceCheckBox = new JCheckBoxMenuItem("Use distances", true);
        useDistanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GelController.this.useDistances = useDistanceCheckBox.isSelected();
                for (GelView view : GelController.this.views) {
                    view.setUseDistance(GelController.this.useDistances);
                    view.revalidate();
                    view.repaint();
                }
            }
        });
        popupMenu.add(useDistanceCheckBox);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GelView source = (GelView)e.getSource();
                int index = source.indexAt(e);
                for (GelView view : GelController.this.views) {
                    view.setSelectedIndex(index);
                    view.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GelController.this.selectedView = (GelView)e.getSource();
                    GelController.this.selectedIndex = GelController.this.selectedView.indexAt(e);
                    setRefIndexAction.setEnabled(GelController.this.selectedIndex != -1);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    public void add(GelModel model) {
        GelView view = new GelView();
        view.setUseDistance(this.useDistances);
        view.addMouseListener(this.mouseListener);
        view.addMouseMotionListener(this.mouseListener);
        view.setModel(model);
        if (this.thetaRankSupplier == null) {
            this.thetaRankSupplier = model;
        }
        if (this.views.size() > 0) {
            view.getModel().setRankSupplier(this.thetaRankSupplier);
        }
        this.views.add(view);
        this.panel.add(view);
        this.panel.revalidate();
        this.panel.repaint();
    }

    public Component getComponent() {
        return this.panel;
    }

    private void changeIndex(final int referenceIndex) {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = new Animator(2000, new TimingTarget(){

            @Override
            public void begin() {
                for (GelView view : GelController.this.views) {
                    InterpolatedGelModel interpolatedModel = new InterpolatedGelModel();
                    interpolatedModel.setInterpolateDistance(true);
                    interpolatedModel.setStart(view.getModel());
                    GelModel endModel = view.getModel().copy();
                    if (endModel.getRankSupplier() != null) {
                        endModel.getRankSupplier().setDistanceMatrixRefIndex(referenceIndex);
                    }
                    endModel.setDistanceMatrixRefIndex(referenceIndex);
                    interpolatedModel.setEnd(endModel);
                    view.setModel(interpolatedModel);
                    view.repaint();
                }
            }

            @Override
            public void end() {
                for (GelView view : GelController.this.views) {
                    InterpolatedGelModel interpolatedModel = (InterpolatedGelModel)view.getModel();
                    GelModel model = interpolatedModel.getEnd();
                    view.setModel(model);
                    view.repaint();
                }
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float fraction) {
                for (GelView view : GelController.this.views) {
                    ((InterpolatedGelModel)view.getModel()).setFraction(fraction);
                    view.repaint();
                }
            }
        });
        this.animator.setInterpolator(new SplineInterpolator(0.0f, 0.0f, 1.0f, 1.0f));
        this.animator.setAcceleration(0.0f);
        this.animator.setDeceleration(0.0f);
        this.animator.start();
    }

    private void changeReference(GelModel newReferenceModel) {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.thetaRankSupplier = newReferenceModel;
        this.animator = new Animator(2000, new TimingTarget(){

            @Override
            public void begin() {
                for (GelView view : GelController.this.views) {
                    InterpolatedGelModel interpolatedModel = new InterpolatedGelModel();
                    interpolatedModel.setStart(view.getModel());
                    GelModelAdapter endModel = new GelModelAdapter(view.getModel()){

                        @Override
                        public float getRankForTheta(int index) {
                            GelModel tmp = GelController.this.thetaRankSupplier.getRankSupplier();
                            GelController.this.thetaRankSupplier.setRankSupplier(null);
                            float rank = GelController.this.thetaRankSupplier.getRankForTheta(index);
                            GelController.this.thetaRankSupplier.setRankSupplier(tmp);
                            return rank;
                        }
                    };
                    interpolatedModel.setEnd(endModel);
                    view.setModel(interpolatedModel);
                    view.repaint();
                }
            }

            @Override
            public void end() {
                for (GelView view : GelController.this.views) {
                    InterpolatedGelModel interpolatedModel = (InterpolatedGelModel)view.getModel();
                    GelModel model = interpolatedModel.getStart();
                    model.setRankSupplier(GelController.this.thetaRankSupplier);
                    view.setModel(model);
                    view.repaint();
                }
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float fraction) {
                for (GelView view : GelController.this.views) {
                    ((InterpolatedGelModel)view.getModel()).setFraction(fraction);
                    view.repaint();
                }
            }
        });
        this.animator.setInterpolator(new SplineInterpolator(0.0f, 0.0f, 1.0f, 1.0f));
        this.animator.setAcceleration(0.0f);
        this.animator.setDeceleration(0.0f);
        this.animator.start();
    }
}

