/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.DefaultGelModel;
import org.broadinstitute.genee.gui.GelController;
import org.broadinstitute.genee.gui.GelModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.OneMinusPearsonCorrelation;
import org.broadinstitute.genee.math.stat.function.bivariate.SpearmanDistance;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.stats.Sorting;

public class GelView
extends JComponent {
    private GelModel model;
    private int xpix0 = 2;
    private int lineLength = 40;
    private WorldCoordinateMapper coordinateMapper;
    private float maxFontSize = 24.0f;
    private float minFontSize = 10.0f;
    private boolean scaleFont;
    private Sorting.FloatIntPair[] coordinateIndexPairs;
    private int selectedIndex = -1;
    private boolean useDistance;
    private boolean viewModeTheta = true;

    public GelView() {
        this.setBackground(Color.WHITE);
    }

    public GelModel getModel() {
        return this.model;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.xpix0 + this.lineLength + 250, 100);
    }

    public int indexAt(MouseEvent e) {
        int index = GelView.binarySearch(this.coordinateIndexPairs, new Sorting.FloatIntPair(e.getY(), -1));
        return index >= 0 ? index : -1;
    }

    public boolean isInitted() {
        return this.coordinateMapper != null;
    }

    public boolean isUseDistance() {
        return this.useDistance;
    }

    public void setModel(GelModel model) {
        this.model = model;
        this.repaint();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public void setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public void toPix(int index, boolean start, Point2D.Float point) {
        float dist = this.model.getDistance(index);
        if (start) {
            point.y = this._yToPix0(dist);
            point.x = this.xpix0;
        } else {
            float rank = this.model.getRankForTheta(index);
            float theta = WorldCoordinateMapper.linearScale(rank, 1.0f, this.model.size(), 405.0f, 315.0f);
            double radians = Math.toRadians(theta);
            point.y = this._yToPix1(dist, radians);
            point.x = (float)this.xpix0 + (float)(Math.cos(radians) * (double)this.lineLength);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw((Graphics2D)g);
    }

    private float _yToPix0(float dist) {
        return this.coordinateMapper.yToPix(dist);
    }

    private float _yToPix1(float dist, double radians) {
        return this._yToPix0(dist) - (float)(Math.sin(radians) * (double)this.lineLength);
    }

    private void draw(Graphics2D g2) {
        if (this.model == null) {
            return;
        }
        g2.setRenderingHints(UIUtil.RENDERING_HINTS);
        int height = this.getHeight();
        this.coordinateMapper = new WorldCoordinateMapper();
        this.coordinateMapper.setTopGutter((float)((double)this.maxFontSize + Math.sin(Math.toRadians(45.0)) * (double)this.lineLength));
        this.coordinateMapper.setBottomGutter(this.coordinateMapper.getTopGutter());
        if (this.useDistance) {
            this.coordinateMapper.setYMax(this.model.getMinDistance());
            this.coordinateMapper.setYMin(this.model.getMaxDistance());
        } else {
            float yPixPerUnit = (float)height - this.coordinateMapper.getBottomGutter() - this.coordinateMapper.getTopGutter();
            this.coordinateMapper.setYMax(0.0f);
            this.coordinateMapper.setYMin(yPixPerUnit / 4.0f);
        }
        this.coordinateMapper.setYPixelScale(height);
        Line2D.Float line = new Line2D.Float();
        Dataset distanceMatrix = this.model.getDistanceMatrix();
        MetadataModel text = MetadataUtil.getTextColumns(distanceMatrix.getColumnMetadata());
        Font font = new Font(UIUtil.getFontName(), 0, 6);
        g2.setFont(font);
        this.coordinateIndexPairs = new Sorting.FloatIntPair[this.model.size()];
        Stroke stroke = g2.getStroke();
        int length = this.model.size();
        for (int j = 0; j < length; ++j) {
            float ypix1;
            float xpix1;
            if (this.selectedIndex == j) {
                g2.setFont(font.deriveFont(16.0f));
                g2.setStroke(new BasicStroke(2.0f));
            } else {
                g2.setFont(font);
                g2.setStroke(stroke);
            }
            float dist = this.useDistance ? this.model.getDistance(j) : this.model.getActualRank(j);
            float rankForTheta = this.model.getRankForTheta(j);
            double radians = Math.toRadians(WorldCoordinateMapper.linearScale(rankForTheta, 1.0f, length, 405.0f, 315.0f));
            float ypix0 = this._yToPix0(dist);
            float actualRank = this.model.getActualRank(j);
            this.viewModeTheta = false;
            if (this.viewModeTheta) {
                xpix1 = (float)this.xpix0 + (float)(Math.cos(radians) * (double)this.lineLength);
                ypix1 = this._yToPix1(dist, radians);
                double radians2 = Math.toRadians(WorldCoordinateMapper.linearScale(actualRank, 1.0f, length, 405.0f, 315.0f));
                float xpix2 = xpix1;
                float ypix2 = this._yToPix1(dist, radians2);
                line.setLine(this.xpix0, ypix0, xpix1, ypix1);
                g2.draw(line);
                line.setLine(this.xpix0, ypix0, xpix2, ypix2);
                g2.setStroke(new BasicStroke(0.5f, 2, 2, 1.0f, new float[]{2.0f}, 0.0f));
                g2.draw(line);
                g2.setStroke(stroke);
            } else {
                float x;
                xpix1 = this.xpix0 + this.lineLength;
                ypix1 = ypix0;
                line.setLine(this.xpix0, ypix0, xpix1, ypix0);
                g2.draw(line);
                float diff = rankForTheta - actualRank;
                float center = (xpix1 - (float)this.xpix0) / 2.0f;
                if (diff > 0.0f) {
                    x = WorldCoordinateMapper.linearScale(diff, 0.0f, length / 2, center, xpix1);
                    line.setLine(x, ypix0, x, ypix0 - 2.0f);
                } else if (diff < 0.0f) {
                    x = WorldCoordinateMapper.linearScale(diff, 0.0f, length / 2, center, this.xpix0);
                    line.setLine(x, ypix0, x, ypix0 - 2.0f);
                }
                g2.draw(line);
            }
            this.coordinateIndexPairs[j] = new Sorting.FloatIntPair(ypix1, j);
            if (this.scaleFont) {
                float size = WorldCoordinateMapper.linearScale(dist, this.model.getMaxDistance(), this.model.getMinDistance(), this.minFontSize, this.maxFontSize);
                g2.setFont(g2.getFont().deriveFont(size));
            }
            String s = ToStringUtil.toString(text, j);
            if (actualRank != rankForTheta) {
                s = s + ", " + Formatter.format(actualRank) + " vs. " + Formatter.format(rankForTheta);
            }
            g2.drawString(s, xpix1 + 2.0f, ypix1 + (float)g2.getFontMetrics().getDescent());
        }
        Arrays.sort(this.coordinateIndexPairs);
    }

    public static void main(String[] args) throws Exception {
        GelView.showTestData1();
    }

    private static int binarySearch(Sorting.FloatIntPair[] a, Sorting.FloatIntPair ypix) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Sorting.FloatIntPair midVal = a[mid];
            int cmp = midVal.compareTo(ypix);
            if (Math.abs(midVal.getValue() - ypix.getValue()) <= 2.0f) {
                return midVal.getIndex();
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static Dataset getDistanceMatrix(Dataset dataset, BivariateFloatListFunction f) {
        RowMajorArray2DDataset distanceDataset = new RowMajorArray2DDataset("Distance", dataset.getRowCount(), dataset.getRowCount());
        distanceDataset.setRowMetadata(dataset.getRowMetadata());
        distanceDataset.setColumnMetadata(distanceDataset.getRowMetadata());
        DatasetRowView datasetView1 = new DatasetRowView(dataset);
        DatasetRowView datasetView2 = new DatasetRowView(dataset);
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            datasetView1.setIndex(i);
            int cols = dataset.getRowCount();
            for (int j = 0; j < cols; ++j) {
                datasetView2.setIndex(j);
                float dist = f.evaluate(datasetView1, datasetView2);
                distanceDataset.setValue(i, j, dist);
            }
        }
        return distanceDataset;
    }

    private static void showTestData1() throws Exception {
        Dataset dataset = ProjectIO.readProject("/Users/jgould/datasets/all_aml_train.gct").getOriginalDataset();
        dataset = DatasetUtil.transposeView(dataset);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        datasets.add(GelView.getDistanceMatrix(dataset, new OneMinusPearsonCorrelation()));
        datasets.add(GelView.getDistanceMatrix(dataset, new SpearmanDistance()));
        GelController controller = new GelController();
        for (Dataset d : datasets) {
            DefaultGelModel model = new DefaultGelModel();
            model.setDistanceMatrix(d);
            model.setDistanceMatrixRefIndex(0);
            controller.add(model);
        }
        UIUtil.showInFrame(controller.getComponent());
    }

    private static void showTestData2() throws Exception {
        String[][] data = ((Array2DContentHandler)new ExcelReader("/Users/jgould/datasets/cpdsig/scores.tab", new Array2DContentHandler()).getContentHandler()).getData();
        ArrayList<RowMajorArray2DDataset> datasets = new ArrayList<RowMajorArray2DDataset>();
        for (int i = 0; i < data.length; ++i) {
            RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", 1, data[0].length);
            datasets.add(dataset);
            for (int j = 0; j < data[0].length; ++j) {
                dataset.setValue(0, j, ParserHelper.parseFloat(data[i][j]));
            }
        }
        GelController controller = new GelController();
        for (Dataset dataset : datasets) {
            DefaultGelModel model = new DefaultGelModel();
            model.setDistanceMatrix(dataset);
            model.setDistanceMatrixRefIndex(0);
            controller.add(model);
        }
        UIUtil.showInFrame(controller.getComponent());
    }
}

