/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.util.HashSet;
import java.util.Set;

public abstract class Highlighter {
    private Set<Object> activeValues = new HashSet<Object>();

    public void addHighlighted(Object value, boolean clear) {
        if (clear) {
            this.activeValues.clear();
        }
        this.activeValues.add(value);
        this.notifyChanged();
    }

    public void clearHighlighted() {
        this.clearHighlighted(true);
    }

    public void clearHighlighted(boolean notify) {
        this.activeValues.clear();
        if (notify) {
            this.notifyChanged();
        }
    }

    public boolean isHighlighted(Object value) {
        return this.activeValues.size() == 0 ? true : this.activeValues.contains(value);
    }

    public boolean isHighlightedEmpty() {
        return this.activeValues.size() == 0;
    }

    public void removeHighlighted(Object value) {
        this.activeValues.remove(value);
        this.notifyChanged();
    }

    protected abstract void notifyChanged();
}

