/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;

public class ProgressPanel
extends JPanel {
    private CoordinateMapper coordinateMapper;
    private float value;
    private Color highlightColor = UIManager.getColor("Slider.highlight");
    private Color shadowColor = UIManager.getColor("Slider.shadow");
    private int trackHeight = 6;

    public ProgressPanel() {
        this.coordinateMapper = new WorldCoordinateMapper();
        this.coordinateMapper.setLeftGutter(0.0f);
        this.coordinateMapper.setXMin(0.0f);
        this.coordinateMapper.setXMax(1.0f);
        this.coordinateMapper.setClipX(true);
        this.setPreferredSize(new Dimension(150, 20));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
    }

    public float getMaxValue() {
        return this.coordinateMapper.getXMax();
    }

    public float getValue() {
        return this.value;
    }

    public float getValue(MouseEvent e) {
        return this.coordinateMapper.pixToX(e.getX());
    }

    public void setMaxValue(float max) {
        this.coordinateMapper.setXMax(max);
        this.repaint();
    }

    public void setValue(float value) {
        this.value = value;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int cw = this.getWidth() - 4;
        int ty = this.getHeight() / 2 - this.trackHeight / 2;
        g.translate(0, ty);
        Color color = this.isEnabled() ? this.shadowColor : this.shadowColor.darker();
        g.setColor(color);
        g.drawLine(0, 0, cw - 1, 0);
        g.drawLine(0, 1, 0, 2);
        g.setColor(this.isEnabled() ? this.highlightColor : this.highlightColor.darker());
        g.drawLine(0, 3, cw, 3);
        g.drawLine(cw, 0, cw, 3);
        g.setColor(this.isEnabled() ? Color.BLACK : Color.GRAY);
        g.drawLine(1, 1, cw - 2, 1);
        this.coordinateMapper.setXPixelScale(this.getWidth());
        float xpix1 = this.coordinateMapper.xToPix(0.0f);
        float pix2 = this.coordinateMapper.xToPix(this.value);
        g.setColor(Color.DARK_GRAY);
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(new Rectangle2D.Float(xpix1, 0.0f, pix2, this.trackHeight));
        g.translate(0, -ty);
    }
}

