/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.broadinstitute.genee.gui.UIUtil;

public class RoundedBorder
implements Border {
    private final Color background;
    private final Color outline;
    private final Color foreground;
    private final int radius;
    private final int stroke;

    public RoundedBorder(Color background, Color outline, Color foreground, int radius, int stroke) {
        this.background = background;
        this.outline = outline;
        this.foreground = foreground;
        this.radius = radius;
        this.stroke = stroke;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.addRenderingHints(UIUtil.RENDERING_HINTS);
        int diameter = this.radius * 2;
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.radius, this.radius);
        g2d.fillRect(width - this.radius, 0, this.radius, this.radius);
        g2d.fillRect(0, height - this.radius, this.radius, this.radius);
        g2d.fillRect(width - this.radius, height - this.radius, this.radius, this.radius);
        int arcLeft = 0;
        int arcTop = 0;
        int arcRight = width - diameter - 1;
        int arcBottom = height - diameter - 1;
        int arcDiameter = diameter;
        int sideWidth = width - diameter;
        int sideHeight = height - diameter;
        g2d.setColor(this.foreground);
        g2d.fillArc(arcLeft, arcTop, arcDiameter, arcDiameter, 90, 90);
        g2d.fillArc(arcRight, arcTop, arcDiameter, arcDiameter, 0, 90);
        g2d.fillArc(arcLeft, arcBottom, arcDiameter, arcDiameter, 180, 90);
        g2d.fillArc(arcRight, arcBottom, arcDiameter, arcDiameter, 270, 90);
        g2d.fillRect(this.radius, 0, sideWidth, this.radius);
        g2d.fillRect(this.radius, height - this.radius, sideWidth, this.radius);
        g2d.fillRect(0, this.radius, this.radius, sideHeight);
        g2d.fillRect(width - this.radius, this.radius, this.radius, sideHeight);
        if (this.stroke > 0) {
            g2d.setColor(this.outline);
            g2d.setStroke(new BasicStroke(this.stroke));
            int halfStroke = this.stroke / 2;
            int strokeDiameter = diameter - this.stroke;
            int leftStroke = halfStroke;
            int rightStroke = width - diameter + halfStroke;
            int topStroke = halfStroke;
            int bottomStroke = height - diameter + halfStroke;
            g2d.drawArc(leftStroke, topStroke, strokeDiameter, strokeDiameter, 90, 90);
            g2d.drawArc(rightStroke, topStroke, strokeDiameter, strokeDiameter, 0, 90);
            g2d.drawArc(leftStroke, bottomStroke, strokeDiameter, strokeDiameter, 180, 90);
            g2d.drawArc(rightStroke, bottomStroke, strokeDiameter, strokeDiameter, 270, 90);
            int sideBottom = height - this.stroke;
            int sideTop = 0;
            int sideLeft = 0;
            int sideRight = width - this.stroke;
            g2d.fillRect(this.radius, sideTop, sideWidth, this.stroke);
            g2d.fillRect(this.radius, sideBottom, sideWidth, this.stroke);
            g2d.fillRect(sideLeft, this.radius, this.stroke, sideHeight);
            g2d.fillRect(sideRight, this.radius, this.stroke, sideHeight);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.radius, this.radius, this.radius, this.radius);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new TestRunnable());
    }

    private static class TestRunnable
    implements Runnable {
        private TestRunnable() {
        }

        @Override
        public void run() {
            JPanel panel = new JPanel(new FlowLayout());
            Color background = new Color(204, 204, 255);
            Color border = Color.BLACK;
            Color foreground = Color.WHITE;
            panel.setBackground(background);
            int p = 50;
            int s = 30;
            JPanel cell = new JPanel();
            cell.add(new JLabel("<html><i>radius</i>: " + p + "<br><i>stroke</i>: " + s));
            cell.setBorder(new RoundedBorder(background, border, foreground, p, s));
            cell.setBackground(Color.WHITE);
            panel.add(cell);
            for (p = 2; p < 20; ++p) {
                for (s = 0; s <= p; ++s) {
                    cell = new JPanel();
                    cell.add(new JLabel("<html><i>radius</i>: " + p + "<br><i>stroke</i>: " + s));
                    cell.setBorder(new RoundedBorder(background, border, foreground, p, s));
                    cell.setBackground(Color.WHITE);
                    panel.add(cell);
                }
            }
            JFrame frame = new JFrame();
            frame.getContentPane().add(panel);
            frame.setSize(640, 480);
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
    }
}

