/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.MultiListEvent;
import org.broadinstitute.genee.gui.MultiListListener;
import org.broadinstitute.genee.gui.ThreeListsComponent;
import org.broadinstitute.genee.gui.parameters.TwoClassComparison;
import org.broadinstitute.genee.gui.parameters.ValidationException;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

class SingleComparisonComponent {
    private ThreeListsComponent selectByMetadata;
    private JLabel numberOfClassASamplesLabel = new JLabel("# of columns: 0");
    private JLabel numberOfClassBSamplesLabel = new JLabel("# of columns: 0");
    private boolean classAIntersection = false;
    private boolean classBIntersection = false;
    private Map<String, List<Integer>> metadataStringToIndices = new HashMap<String, List<Integer>>();
    private JLabel columnsInBothClassAAndB = new JLabel(" ");

    SingleComparisonComponent() {
        this.selectByMetadata = new ThreeListsComponent("Class A", " ", "Class B", true){

            @Override
            protected JComponent createBottomListComponent(int index) {
                if (index == 0) {
                    return SingleComparisonComponent.this.createCombineCategoriesComponent(true);
                }
                if (index == 1) {
                    FormBuilder formBuilder = new FormBuilder();
                    formBuilder.nextRow();
                    formBuilder.addSpanned(SingleComparisonComponent.this.columnsInBothClassAAndB);
                    return formBuilder.getPanel();
                }
                if (index == 2) {
                    return SingleComparisonComponent.this.createCombineCategoriesComponent(false);
                }
                return null;
            }
        };
        this.selectByMetadata.setRemoveFromCenter(false);
        for (int i = 0; i < 3; ++i) {
            this.selectByMetadata.getJList(i).setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public void setText(String text) {
                    List samples = (List)SingleComparisonComponent.this.metadataStringToIndices.get(text);
                    if (samples != null) {
                        text = text + " (" + samples.size() + ")";
                    }
                    this.setToolTipText(text);
                    super.setText(text);
                }
            });
        }
        this.selectByMetadata.addMultiListSelection(new MultiListListener(){

            @Override
            public void valueChanged(MultiListEvent e) {
                SingleComparisonComponent.this.updateNumberOfClassAColumns();
                SingleComparisonComponent.this.updateNumberOfClassBColumns();
                SingleComparisonComponent.this.updateClassAAndBIntersection();
            }
        });
    }

    public TwoClassComparison[] getTwoClassComparison(String parameterName) {
        Set<Integer> rightIndices;
        Set<Integer> leftIndices = this.getClassAColumnIndices();
        Sets.SetView result = Sets.intersection(leftIndices, rightIndices = this.getClassBColumnIndices());
        if (result.size() > 0) {
            throw new ValidationException("The following columns are in both class A and class B: " + ToStringUtil.toString(result, ", "));
        }
        return new TwoClassComparison[]{new TwoClassComparison(this.getComparisonName(), leftIndices, rightIndices)};
    }

    private String getComparisonName() {
        String name = "";
        List<String> left = this.selectByMetadata.getLeftItems();
        List<String> right = this.selectByMetadata.getRightItems();
        if (left.size() == 1 && right.size() == 1) {
            name = left.get(0) + " vs. " + right.get(0);
        }
        return name;
    }

    public void setProject(Project project) {
        Dataset dataset = project.getSortedFilteredDataset();
        MetadataModel metadata = dataset.getColumnMetadata();
        this.metadataStringToIndices.clear();
        ArrayList<String> metadataNames = new ArrayList<String>();
        int metadataSize = metadata.getMetadataCount();
        for (int i = 0; i < metadataSize; ++i) {
            Vector vector = metadata.get(i);
            metadataNames.add(vector.getName());
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            int nrows = metadata.getItemCount();
            for (int j = 0; j < nrows; ++j) {
                Object val = vector.getValue(j);
                if (val == null) continue;
                set.add(val);
            }
            Set<Object> categories = VectorUtil.getValues(vector);
            for (Object val : categories) {
                this.metadataStringToIndices.put(vector.getName() + " " + val, new ArrayList());
            }
            int nrows2 = metadata.getItemCount();
            for (int j = 0; j < nrows2; ++j) {
                Object value = vector.getValue(j);
                if (value == null) continue;
                List<Integer> samples = this.metadataStringToIndices.get(vector.getName() + " " + value);
                if (samples == null) {
                    throw new RuntimeException("No set found for " + vector.getName() + " " + value + " in " + this.metadataStringToIndices.keySet());
                }
                samples.add(j);
            }
        }
        for (String categoryName : this.metadataStringToIndices.keySet().toArray(new String[0])) {
            List<Integer> samples = this.metadataStringToIndices.get(categoryName);
            this.metadataStringToIndices.remove(categoryName);
            this.metadataStringToIndices.put(categoryName, samples);
        }
        this.selectByMetadata.setItems(new ArrayList<String>(), new ArrayList<String>(this.metadataStringToIndices.keySet()), new ArrayList<String>());
    }

    private JComponent createCombineCategoriesComponent(final boolean classA) {
        ButtonGroupHelper bg = new ButtonGroupHelper();
        final JRadioButton intersectionBtn = bg.createRadioButton("Intersection");
        JRadioButton unionBtn = bg.createRadioButton("Union", true);
        bg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (classA) {
                    SingleComparisonComponent.this.classAIntersection = intersectionBtn.isSelected();
                    SingleComparisonComponent.this.updateNumberOfClassAColumns();
                } else {
                    SingleComparisonComponent.this.classBIntersection = intersectionBtn.isSelected();
                    SingleComparisonComponent.this.updateNumberOfClassBColumns();
                }
                SingleComparisonComponent.this.updateClassAAndBIntersection();
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addSpanned(classA ? this.numberOfClassASamplesLabel : this.numberOfClassBSamplesLabel);
        formBuilder.nextRow();
        formBuilder.addLabel("Combine Categories:");
        formBuilder.add(intersectionBtn);
        formBuilder.nextSmallRow();
        formBuilder.add(unionBtn);
        return formBuilder.getPanel();
    }

    private Set<Integer> getClassAColumnIndices() {
        List<String> categories = this.selectByMetadata.getLeftItems();
        return this.getIndices(categories, this.classAIntersection);
    }

    private Set<Integer> getClassBColumnIndices() {
        List<String> categories = this.selectByMetadata.getRightItems();
        return this.getIndices(categories, this.classBIntersection);
    }

    private Set<Integer> getIndices(List<String> categories, boolean intersection) {
        LinkedHashSet<Integer> results = new LinkedHashSet<Integer>();
        int ncategories = categories.size();
        for (int i = 0; i < ncategories; ++i) {
            String category = categories.get(i);
            List<Integer> samples = this.metadataStringToIndices.get(category);
            if (samples == null) {
                System.out.println("No samples found for " + category);
                continue;
            }
            if (!intersection) {
                results.addAll(samples);
                continue;
            }
            if (i == 0) {
                results.addAll(samples);
                continue;
            }
            results.retainAll(samples);
        }
        return results;
    }

    private void updateClassAAndBIntersection() {
        HashSet<Integer> right;
        HashSet<Integer> left = new HashSet<Integer>(this.getClassAColumnIndices());
        int size = Sets.intersection(left, right = new HashSet<Integer>(this.getClassBColumnIndices())).size();
        this.columnsInBothClassAAndB.setText(size == 0 ? "" : "Error: " + size + " columns in both class A and class B");
    }

    private void updateNumberOfClassAColumns() {
        this.numberOfClassASamplesLabel.setText("# of columns: " + this.getIndices(this.selectByMetadata.getLeftItems(), this.classAIntersection).size());
    }

    private void updateNumberOfClassBColumns() {
        this.numberOfClassBSamplesLabel.setText("# of columns: " + this.getIndices(this.selectByMetadata.getRightItems(), this.classBIntersection).size());
    }

    public Component getComponent() {
        return this.selectByMetadata.getComponent();
    }
}

