/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.GENEEDefaultListCellRenderer;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.MultiListEvent;
import org.broadinstitute.genee.gui.MultiListListener;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.dnd.DndUtil;
import org.broadinstitute.genee.gui.dnd.DragHelper;
import org.broadinstitute.genee.gui.dnd.ListDndUtil;
import org.broadinstitute.genee.heatmap.QuickListFilter;

public class ThreeListsComponent {
    private static final int CENTER = 1;
    private static final int LEFT = 0;
    private static final int RIGHT = 2;
    private String leftListName = "class A";
    private EventListenerList listenerList = new EventListenerList();
    private JList[] lists;
    private JPanel[] panels;
    private String rightListName = "class B";
    private JideSplitPane splitPane = new JideSplitPane(1);
    private boolean removeFromCenter = true;

    public ThreeListsComponent(String leftItemLabel, String centerItemLabel, String rightItemLabel, boolean searchTextBoxVisible) {
        this.splitPane.setProportionalLayout(true);
        this.lists = new JList[3];
        this.panels = new JPanel[3];
        this.addList(0, searchTextBoxVisible, leftItemLabel);
        this.addList(1, searchTextBoxVisible, centerItemLabel);
        this.addList(2, searchTextBoxVisible, rightItemLabel);
        for (JList list : this.lists) {
            try {
                this.addDndSupport(list);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
    }

    public void addMultiListSelection(MultiListListener l) {
        this.listenerList.add(MultiListListener.class, l);
    }

    public void addToList(int index, String[] items) {
        FilterableListModel model = (FilterableListModel)((Object)this.lists[index].getModel());
        DefaultListModel actualModel = (DefaultListModel)model.getActualModel();
        HashSet<Object> values = new HashSet<Object>(Arrays.asList(actualModel.toArray()));
        int length = this.lists.length;
        for (int i = 0; i < length; ++i) {
            model = (FilterableListModel)((Object)this.lists[i].getModel());
            for (String item : items) {
                if (i == index) {
                    if (values.contains(item)) continue;
                    model.addElement(item);
                    continue;
                }
                model.removeElement(item);
            }
        }
    }

    public List<String> getCenterItems() {
        return this.getItems(1);
    }

    public JComponent getComponent() {
        return this.splitPane;
    }

    public JList getJList(int position) {
        return this.lists[position];
    }

    public List<String> getLeftItems() {
        return this.getItems(0);
    }

    public List<String> getRightItems() {
        return this.getItems(2);
    }

    public void move(int source, int dest, Object[] items) {
        FilterableListModel sourceModel = (FilterableListModel)((Object)this.lists[source].getModel());
        FilterableListModel destModel = (FilterableListModel)((Object)this.lists[dest].getModel());
        for (Object item : items) {
            int priorIndex = sourceModel.indexOf(item);
            if (this.removeFromCenter) {
                sourceModel.removeElement(item);
            }
            if (priorIndex < 0) continue;
            destModel.addElement(item);
        }
    }

    public void removeMultiListSelection(MultiListListener l) {
        this.listenerList.remove(MultiListListener.class, l);
    }

    public void setCenterLabel(String label) {
        this.panels[1].setBorder(BorderFactory.createTitledBorder(label));
    }

    public void setItemLabels(String left, String right) {
        this.panels[0].setBorder(BorderFactory.createTitledBorder(left));
        this.panels[2].setBorder(BorderFactory.createTitledBorder(right));
    }

    public void setItems(List<String> leftItems, List<String> centerItems, List<String> rightItems) {
        DefaultListModel leftModel = (DefaultListModel)((FilterableListModel)((Object)this.lists[0].getModel())).getActualModel();
        DefaultListModel rightModel = (DefaultListModel)((FilterableListModel)((Object)this.lists[2].getModel())).getActualModel();
        Object[] savedLeftItems = leftModel.toArray();
        Object[] savedRightItems = rightModel.toArray();
        this.setItems(leftItems, this.lists[0]);
        this.setItems(centerItems, this.lists[1]);
        this.setItems(rightItems, this.lists[2]);
        this.move(1, 0, savedLeftItems);
        this.move(1, 2, savedRightItems);
    }

    public void setLeftListName(String leftListName) {
        this.leftListName = leftListName;
    }

    public void setRemoveFromCenter(boolean removeFromCenter) {
        this.removeFromCenter = removeFromCenter;
    }

    public void setRightListName(String rightListName) {
        this.rightListName = rightListName;
    }

    protected JComponent createBottomListComponent(int index) {
        return null;
    }

    private void addDndSupport(final JList list) throws Exception {
        new DragHelper(list, new ListDndUtil.ListTransferHandler(), 2);
        DndUtil.setDropEnabled(list, new Class[]{String.class}, 2, new ListDndUtil.ReorderOrMoveListElementsCallback(new ListDndUtil.ListDropCallback(){

            @Override
            public void dropNotify(JList sourceList, JList destList, Object[] selection) {
                ThreeListsComponent.this.fireListSelectionEvent(new MultiListEvent(this, Arrays.asList(ThreeListsComponent.this.lists).indexOf(sourceList), Arrays.asList(ThreeListsComponent.this.lists).indexOf(list), Arrays.asList(selection)));
            }
        }));
    }

    private void addList(int index, boolean searchTextBoxVisible, String label) {
        JComponent c;
        FilterableListModel listModel = new FilterableListModel();
        JList<Object> list = new JList<Object>((ListModel<Object>)((Object)listModel));
        list.setPrototypeCellValue("AAAAAAAAAAAA");
        list.setCellRenderer(new GENEEDefaultListCellRenderer());
        JPanel btnPanel = index != 2 ? this.createButtonPanel(index) : null;
        JPanel p = new JPanel((LayoutManager)new JideBorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel(label), "North");
        if (searchTextBoxVisible) {
            topPanel.add((Component)new QuickListFilter(list.getSelectionModel(), listModel){

                @Override
                protected String getSavedSearchKey() {
                    return null;
                }
            }.getComponent(), "Center");
        }
        topPanel.setMinimumSize(new Dimension(0, 0));
        JScrollPane sp = UIUtil.createNoBorderScrollPane(list);
        sp.setMinimumSize(new Dimension(0, 0));
        p.add(sp);
        p.add((Component)topPanel, "North");
        if (btnPanel != null) {
            p.add((Component)btnPanel, "East");
        }
        if ((c = this.createBottomListComponent(index)) != null) {
            p.add((Component)c, "South");
        }
        this.lists[index] = list;
        this.panels[index] = p;
        p.setMinimumSize(new Dimension(0, 0));
        this.splitPane.addPane((Component)p);
    }

    private JPanel createButtonPanel(final int position) {
        JPanel panel = new JPanel((LayoutManager)new FormLayout("pref:none", "15px, pref:none, 5px, pref:none"));
        CellConstraints cc = new CellConstraints();
        final JideButton moveToClassBtn = new JideButton((Icon)(position == 0 ? IconManager.loadIcon("16x16/31961.m_arrow.png") : IconManager.loadIcon("16x16/31959.arrow.png")));
        moveToClassBtn.setToolTipText("Move the selected items to " + (position == 0 ? this.leftListName : this.rightListName));
        JideButton deleteBtn = new JideButton((Icon)IconManager.loadIcon("16x16/14763.delete.gif"));
        deleteBtn.setToolTipText("Delete the selected items from " + (position == 0 ? this.leftListName : this.rightListName));
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterableListModel leftModel = (FilterableListModel)((Object)ThreeListsComponent.this.lists[0].getModel());
                FilterableListModel centerModel = (FilterableListModel)((Object)ThreeListsComponent.this.lists[1].getModel());
                FilterableListModel rightModel = (FilterableListModel)((Object)ThreeListsComponent.this.lists[2].getModel());
                if (e.getSource() == moveToClassBtn) {
                    Object[] selected = ThreeListsComponent.this.lists[1].getSelectedValues();
                    FilterableListModel addTo = position == 0 ? leftModel : rightModel;
                    ArrayList<String> changedItems = new ArrayList<String>();
                    for (Object obj : selected) {
                        if (ThreeListsComponent.this.removeFromCenter) {
                            centerModel.removeElement((String)obj);
                        }
                        addTo.addElement((String)obj);
                        changedItems.add((String)obj);
                    }
                    ThreeListsComponent.this.fireListSelectionEvent(new MultiListEvent(ThreeListsComponent.this, 1, position == 0 ? 0 : 2, changedItems));
                } else {
                    Object[] selected = ThreeListsComponent.this.lists[position == 0 ? 0 : 2].getSelectedValues();
                    FilterableListModel removeFrom = position == 0 ? leftModel : rightModel;
                    ArrayList<String> changedItems = new ArrayList<String>();
                    for (Object obj : selected) {
                        removeFrom.removeElement((String)obj);
                        if (ThreeListsComponent.this.removeFromCenter) {
                            centerModel.addElement((String)obj);
                        }
                        changedItems.add((String)obj);
                    }
                    ThreeListsComponent.this.fireListSelectionEvent(new MultiListEvent(ThreeListsComponent.this, position == 0 ? 0 : 2, 1, changedItems));
                }
            }
        };
        moveToClassBtn.addActionListener(l);
        deleteBtn.addActionListener(l);
        panel.add((Component)moveToClassBtn, cc.xy(1, 2));
        panel.add((Component)deleteBtn, cc.xy(1, 4));
        return panel;
    }

    private void fireListSelectionEvent(MultiListEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MultiListListener.class) continue;
            ((MultiListListener)listeners[i + 1]).valueChanged(e);
        }
    }

    private List<String> getItems(int index) {
        FilterableListModel model = (FilterableListModel)((Object)this.lists[index].getModel());
        ArrayList<String> list = new ArrayList<String>();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            list.add((String)model.getElementAt(i));
        }
        return list;
    }

    private void setItems(List<String> items, JList list) {
        FilterableListModel model = (FilterableListModel)((Object)list.getModel());
        Collections.sort(items, String.CASE_INSENSITIVE_ORDER);
        model.setItems(items);
    }
}

