/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.factories.CC;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.gui.AbstractComparisonComponent;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.FilterableCheckBoxList;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class TwoClassComparisonComponent
extends AbstractComparisonComponent {
    private String classAName;
    private String classBName;
    private CheckBoxList[] lists;
    private JPanel panel;
    private JideSplitPane splitPane;
    private boolean groupByVisible;

    public TwoClassComparisonComponent() {
        this(false, true, "Class A", "Class B");
    }

    public TwoClassComparisonComponent(boolean inModelSpace, boolean groupByVisible, String classAName, String classBName) {
        super(inModelSpace);
        this.groupByVisible = groupByVisible;
        this.classAName = classAName;
        this.classBName = classBName;
        this.init();
    }

    @Override
    public JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public List<String> getSelectedFields() {
        Object[] selection = this.lists[1].getCheckBoxListSelectedValues();
        ArrayList<String> selectedMetadataNames = new ArrayList<String>();
        for (Object obj : selection) {
            selectedMetadataNames.add((String)obj);
        }
        return selectedMetadataNames;
    }

    public void addComparisonListener(ListSelectionListener l) {
        this.lists[0].getCheckBoxListSelectionModel().addListSelectionListener(l);
        this.lists[2].getCheckBoxListSelectionModel().addListSelectionListener(l);
    }

    @Override
    protected List<Combination>[] getSelectedCombinations() {
        Dataset dataset = this.getDataset();
        List<Combination> c1 = TwoClassComparisonComponent.getSelectedClassCombinations((JList)this.lists[0], dataset.getColumnMetadata());
        List<Combination> c2 = TwoClassComparisonComponent.getSelectedClassCombinations((JList)this.lists[2], dataset.getColumnMetadata());
        return new List[]{c1, c2};
    }

    protected void init() {
        this.splitPane = new JideSplitPane();
        this.lists = new CheckBoxList[3];
        this.addList(0, this.classAName);
        this.addList(1, "Annotations");
        this.lists[1].getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TwoClassComparisonComponent.this.updateCombinations();
            }
        });
        this.lists[1].getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TwoClassComparisonComponent.this.updateCombinations();
            }
        });
        this.addList(2, this.classBName);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.splitPane);
        if (this.groupByVisible) {
            this.panel.add((Component)this.groupByFormBuilder.getPanel(), "South");
        }
    }

    @Override
    protected void setProject(Project project) {
        this.setMetadataNames(new ArrayList<String>(MetadataUtil.getNames(project.getOriginalDataset().getColumnMetadata())));
    }

    private void addList(int index, String label) {
        FilterableCheckBoxList list = new FilterableCheckBoxList(label);
        this.lists[index] = list.getCheckBoxList();
        this.splitPane.add((Component)list.getComponent(), (Object)CC.xy((int)(index + 1), (int)1));
    }

    private JComponent createCombineCategoriesComponent(final boolean classA) {
        ButtonGroupHelper bg = new ButtonGroupHelper();
        final JRadioButton intersectionBtn = bg.createRadioButton("AND");
        JRadioButton unionBtn = bg.createRadioButton("OR", true);
        bg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (classA) {
                    TwoClassComparisonComponent.this.classAIntersection = intersectionBtn.isSelected();
                } else {
                    TwoClassComparisonComponent.this.classBIntersection = intersectionBtn.isSelected();
                }
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Combine values:");
        formBuilder.add(intersectionBtn);
        formBuilder.nextSmallRow();
        formBuilder.add(unionBtn);
        return formBuilder.getPanel();
    }

    private void setMetadataNames(List<String> names) {
        Object[] selection0 = this.lists[0].getCheckBoxListSelectedValues();
        Object[] selection1 = this.lists[1].getCheckBoxListSelectedValues();
        Object[] selection2 = this.lists[2].getCheckBoxListSelectedValues();
        FilterableListModel model = (FilterableListModel)((Object)this.lists[1].getModel());
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        model.setItems(names);
        if (selection1 != null && selection1.length > 0) {
            this.lists[1].clearCheckBoxListSelection();
            this.lists[1].addCheckBoxListSelectedValues(selection1);
            this.lists[0].clearCheckBoxListSelection();
            this.lists[0].addCheckBoxListSelectedValues(selection0);
            this.lists[2].clearCheckBoxListSelection();
            this.lists[2].addCheckBoxListSelectedValues(selection2);
        } else if (this.firstTime && names.contains("pert_desc")) {
            this.lists[1].addCheckBoxListSelectedValue((Object)"pert_desc", true);
        }
    }

    private void updateCombinations() {
        List<String> selectedFields = this.getSelectedFields();
        Vector[] vectors = MetadataUtil.getVectors(this.getDataset().getColumnMetadata(), selectedFields.toArray(new String[0]));
        List<Combination> combinations = VectorUtil.getCombinations(vectors);
        Object[] tmp = this.lists[0].getCheckBoxListSelectedValues();
        ((FilterableListModel)((Object)this.lists[0].getModel())).setItems(combinations);
        this.lists[0].setSelectedObjects(tmp);
        tmp = this.lists[2].getCheckBoxListSelectedValues();
        ((FilterableListModel)((Object)this.lists[2].getModel())).setItems(combinations);
        this.lists[2].setSelectedObjects(tmp);
        int[] locations = this.splitPane.getDividerLocations();
        this.lists[0].revalidate();
        this.lists[0].repaint();
        this.lists[2].revalidate();
        this.lists[2].repaint();
        this.splitPane.setDividerLocations(locations);
    }
}

