/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.broadinstitute.genee.gui.UIUtil;

public class XIcon
implements Icon {
    private final Color foreground;
    private final int fraction;
    private final int size;

    public XIcon() {
        this(10, 5, Color.BLACK.brighter());
    }

    public XIcon(int size, int fraction, Color foreground) {
        this.size = size;
        this.fraction = fraction;
        this.foreground = foreground;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.addRenderingHints(UIUtil.RENDERING_HINTS);
        g2d.setColor(this.foreground);
        int oneSixth = this.size / this.fraction;
        int fiveSixths = this.size - oneSixth;
        g2d.fillPolygon(new int[]{x + oneSixth, x + this.size, x + fiveSixths, x}, new int[]{y, y + fiveSixths, y + this.size, y + oneSixth}, 4);
        g2d.fillPolygon(new int[]{x, x + fiveSixths, x + this.size, x + oneSixth}, new int[]{y + fiveSixths, y, y + oneSixth, y + this.size}, 4);
    }
}

