/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.parameters.CheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.math.stat.CollapseDataset;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class CollapseDatasetUI {
    private static final String COLLAPSE_METHOD_PARAMETER = "Collapse method";
    private static final String L_PARAMETER = "The number of largest elements to trim away (l >= 0)";
    private static final String REPLICATE_DEFINITION = "Replicate definition";
    private static final String S_PARAMETER = "The number of smallest elements to trim away (s >= 0)";
    private CheckBoxListParameter checkBoxListParameter;
    static final String COLLAPSE_ROWS_OR_COLUMNS = "Collapse";
    private boolean isRows = true;

    public CollapseDatasetUI(AbstractInputAction inputAction) {
        final ComboBoxParameter c = new ComboBoxParameter(new Object[]{CollapseMethodOption.MAX, CollapseMethodOption.MEAN, CollapseMethodOption.MEDIAN, CollapseMethodOption.MIN, CollapseMethodOption.TRIMMED_MEAN, CollapseMethodOption.MAX_AVERAGE_PROBE, CollapseMethodOption.MAX_MEDIAN_PROBE, CollapseMethodOption.STANDARD_DEVIATION}, 2);
        final ComboBoxParameter collapseRowsOrColumnsComboBox = new ComboBoxParameter((Object[])new String[]{"Columns", "Rows"}, 1);
        collapseRowsOrColumnsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapseDatasetUI.this.setRows(collapseRowsOrColumnsComboBox.getSelectedIndex() == 1);
            }
        });
        inputAction.addParameter(COLLAPSE_ROWS_OR_COLUMNS, collapseRowsOrColumnsComboBox, false);
        inputAction.addParameter(COLLAPSE_METHOD_PARAMETER, c, true);
        this.checkBoxListParameter = new CheckBoxListParameter();
        this.updateChoices();
        final IntegerInputParameter sTextParam = new IntegerInputParameter();
        inputAction.addIndentedParameter(S_PARAMETER, sTextParam, false, 1);
        sTextParam.setEnabled(false);
        final IntegerInputParameter lTextParam = new IntegerInputParameter();
        inputAction.addIndentedParameter(L_PARAMETER, lTextParam, false, 1);
        lTextParam.setEnabled(false);
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = c.getSelectedItem() == CollapseMethodOption.TRIMMED_MEAN;
                sTextParam.setEnabled(enabled);
                lTextParam.setEnabled(enabled);
            }
        });
        inputAction.addParameter(REPLICATE_DEFINITION, this.checkBoxListParameter, true);
    }

    public static CollapseDataset getCollapseDataset(Map<String, Object> map) {
        Integer s = (Integer)map.get(S_PARAMETER);
        Integer l = (Integer)map.get(L_PARAMETER);
        CollapseMethodOption collapseMethodOption = (CollapseMethodOption)((Object)map.get(COLLAPSE_METHOD_PARAMETER));
        Object[] replicateDefinition = (Object[])map.get(REPLICATE_DEFINITION);
        String[] tmp = new String[replicateDefinition.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (String)replicateDefinition[i];
        }
        CollapseDataset collapseReplicates = new CollapseDataset();
        collapseReplicates.setCollapseTo(tmp);
        collapseReplicates.setCollapseMethod(collapseMethodOption);
        if (l != null) {
            collapseReplicates.setTrimmedMeanL(l);
        }
        if (s != null) {
            collapseReplicates.setTrimmedMeanS(s);
        }
        return collapseReplicates;
    }

    public void setRows(boolean isRows) {
        this.isRows = isRows;
        this.updateChoices();
    }

    public void updateChoices() {
        Project p = Application.getProject();
        if (p != null) {
            List<String> choices = MetadataUtil.getNames(this.isRows ? p.getOriginalDataset().getRowMetadata() : p.getOriginalDataset().getColumnMetadata());
            this.checkBoxListParameter.init(choices.toArray(new String[0]));
        }
    }
}

