/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.heatmap.AbstractNodesAction;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeSupplier;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class ConcatenateAction
extends AbstractNodesAction {
    private boolean concatRows;

    public ConcatenateAction(boolean concatRows) {
        super("Concatenate " + (concatRows ? "Rows" : "Columns"), !concatRows, concatRows);
        this.setDescription("Merges two datasets by concatenating " + (concatRows ? "rows" : "columns"));
        this.concatRows = concatRows;
    }

    @Override
    protected boolean accept(ProjectGENEEResultTreeNode selectedNode, ProjectGENEEResultTreeNode child) {
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProjectGENEEResultTreeNode selectedNode, String selectedNodeRowField, String selectedNodeColumnField, final ProjectGENEEResultTreeNode childNode, String childNodeRowField, String childNodeColumnField) {
        Dataset appendToReference;
        Dataset reference;
        List<String> matchOn;
        if (!this.concatRows) {
            matchOn = Arrays.asList(selectedNodeRowField, childNodeRowField);
            reference = DatasetUtil.transposeView(selectedNode.getProject().getOriginalDataset());
            appendToReference = DatasetUtil.transposeView(childNode.getProject().getOriginalDataset());
        } else {
            matchOn = Arrays.asList(selectedNodeColumnField, childNodeColumnField);
            reference = selectedNode.getProject().getOriginalDataset();
            appendToReference = childNode.getProject().getOriginalDataset();
        }
        Dataset result = DatasetUtil.concatenateRows(reference, appendToReference, matchOn.get(0), matchOn.get(1), reference.getName());
        if (!this.concatRows) {
            result = DatasetUtil.transposeView(result);
        }
        History history = this.getHistory(map);
        Project project = (Project)map.get("project");
        DefaultProject newProject = new DefaultProject(result, project);
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode((Project)newProject, history, new ComponentCustomizer(){

            @Override
            public void customize(Component c) {
                if (ConcatenateAction.this.concatRows) {
                    HeatMapPanel p = (HeatMapPanel)c;
                    HeatMapColorSchemeSupplier cs = (HeatMapColorSchemeSupplier)p.getColorScheme();
                    cs.setSeparateColorSchemesForRowMetadataField("Source");
                    cs.setCurrentValue(childNode.getProject().getOriginalDataset().getName());
                    cs.setColorScheme(((HeatMapPanel)childNode.getDisplayInfo().getComponent()).getColorScheme().copy());
                }
            }

            @Override
            public boolean inherits() {
                return false;
            }
        });
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

