/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.cmdline.BasicCmdLineArgs;
import org.broadinstitute.genee.cmdline.CmdLineUtil;
import org.broadinstitute.genee.gui.actions.ToolRunner;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;
import uk.co.flamingpenguin.jewel.cli.Unparsed;

public class GeneeToolRunner {
    public static Project[] execute(GeneeToolRunnerArgs argsp) throws Exception {
        Project p = ProjectIO.readProject(argsp.getInputDataset());
        List<String> rowIds = argsp.getRowIds();
        int[] rowIndices = null;
        if (rowIds != null) {
            Vector ids;
            if (rowIds.size() == 1 && new File(rowIds.get(0)).exists()) {
                rowIds = new ArrayList<String>(GeneSetIO.readGeneSetMatrix(rowIds.get(0)).get(0).getMembers());
            }
            if ((ids = p.getOriginalDataset().getRowMetadata().get("id")) == null) {
                ids = p.getOriginalDataset().getRowMetadata().get("Id");
            }
            rowIndices = CmdLineUtil.getIndicesForValues(ids, rowIds, true);
        }
        List<String> columnIds = argsp.getColumnIds();
        int[] columnIndices = null;
        if (columnIds != null) {
            Vector ids;
            if (columnIds.size() == 1 && new File(columnIds.get(0)).exists()) {
                columnIds = new ArrayList<String>(GeneSetIO.readGeneSetMatrix(columnIds.get(0)).get(0).getMembers());
            }
            if ((ids = p.getOriginalDataset().getColumnMetadata().get("id")) == null) {
                ids = p.getOriginalDataset().getColumnMetadata().get("Id");
            }
            columnIndices = CmdLineUtil.getIndicesForValues(ids, columnIds, true);
        }
        p.setDataset(DatasetUtil.sliceView(p.getOriginalDataset(), rowIndices, columnIndices));
        ToolRunner runner = new ToolRunner(argsp.getTool(), p);
        if (argsp.getUnparsed() != null) {
            for (String arg : argsp.getUnparsed()) {
                String[] keyVal = arg.split("=");
                runner.setParameterValue(keyVal[0], keyVal[1]);
            }
        }
        return runner.execute();
    }

    public static Project[] execute(String toolName, Dataset dataset, Map.Entry<String, String> ... parameters) throws Exception {
        ToolRunner runner = new ToolRunner(toolName, new DefaultProject(dataset));
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters) {
                runner.setParameterValue(e.getKey(), e.getValue());
            }
        }
        return runner.execute();
    }

    public static void main(String[] args) {
        File dir = null;
        try {
            Cli cli = CliFactory.createCli(GeneeToolRunnerArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            GeneeToolRunnerArgs argsp = (GeneeToolRunnerArgs)cli.parseArguments(args);
            dir = new File(argsp.getOutputDir());
            dir.mkdirs();
            Project[] projects = GeneeToolRunner.execute(argsp);
            for (int i = 0; i < projects.length; ++i) {
                Project p = projects[i];
                File f = new File(dir, p.getOriginalDataset().getName());
                ProjectIO.writeProject(p, "gctx", f.getCanonicalPath(), true);
                System.out.println("Wrote " + f);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            try {
                File f = IOUtil.getUniqueFile(dir.getCanonicalPath(), "stderr", ".txt");
                Files.write((CharSequence)ToStringUtil.toString(x), (File)f, (Charset)Charset.defaultCharset());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void setHeadless(boolean b) {
        System.setProperty("java.awt.headless", String.valueOf(b));
    }

    static {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("org.broadinstitute.genee.commandLine", "true");
    }

    @CommandLineInterface(application="genee_tool_runner")
    public static interface GeneeToolRunnerArgs
    extends BasicCmdLineArgs {
        @Option(longName={"tool"}, description="GENE-E tool (e.g. \"Hierarchical Clustering\"")
        public String getTool();

        @Option(longName={"output"}, shortName={"o"}, description="Output directory")
        public String getOutputDir();

        @Unparsed(name="unparsed")
        public List<String> getUnparsed();
    }
}

