/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.kmeans.KMeansClusterer;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.ClusteringActionUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.gui.parameters.CheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.IntegerInputParameter;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class KMeansAction
extends AbstractInputAction {
    private static final String CLUSTER_COLUMNS = "Cluster columns";
    private static final String CLUSTER_COLUMNS_ROW_SPACE = "Cluster columns in space of selected rows only";
    private static final String CLUSTER_ROWS = "Cluster rows";
    private static final String CLUSTER_ROWS_COLUMN_SPACE = "Cluster rows in space of selected columns only";
    private static final String COLUMN_DIST_METRIC = "Column distance metric";
    private static final String COLUMNS_CLUSTER_SELECTED_COLUMNS = "Cluster selected columns only";
    private static final String COLUMNS_CLUSTERS = "Column clusters";
    private static final String COLUMNS_ITERATIONS = "Column iterations";
    private static final String GROUP_COLUMNS_BY = "Group columns by";
    private static final String GROUP_COLUMNS_ENABLED = "Group columns";
    private static final String GROUP_ROWS_BY = "Group rows by";
    private static final String GROUP_ROWS_ENABLED = "Group rows";
    private static final String ROW_DIST_METRIC = "Row distance metric";
    private static final String ROWS_CLUSTER_SELECTED_ROWS = "Cluster selected rows only";
    private static final String ROWS_CLUSTERS = "Row clusters";
    private static final String ROWS_ITERATIONS = "Row iterations";
    private static final String SELECTED_COLUMN_INDICES_KEY = "Selected column indices";
    private static final String SELECTED_ROW_INDICES_KEY = "Selected row indices";
    private CheckBoxListParameter columnMetadataSelectorParameter;
    private ComboBoxParameter columnMetricComboBox;
    private CheckBoxListParameter rowMetadataSelectorParameter;
    private ComboBoxParameter rowMetricComboBox;

    public KMeansAction() {
        super("K-Means Clustering");
        ArrayList<BasicMapEntry<DistanceFunction>> columnMetrics = new ArrayList<BasicMapEntry<DistanceFunction>>();
        columnMetrics.addAll(Arrays.asList(ClusteringActionUtil.DISTANCE_METRICS));
        ArrayList<BasicMapEntry<DistanceFunction>> rowMetrics = new ArrayList<BasicMapEntry<DistanceFunction>>();
        rowMetrics.addAll(Arrays.asList(ClusteringActionUtil.DISTANCE_METRICS));
        this.columnMetricComboBox = new ComboBoxParameter((Object[])columnMetrics.toArray(new BasicMapEntry[0]), ClusteringActionUtil.PEARSON);
        this.rowMetricComboBox = new ComboBoxParameter((Object[])rowMetrics.toArray(new BasicMapEntry[0]), ClusteringActionUtil.PEARSON);
        CheckBoxParameter clusterColumnsCheckBox = new CheckBoxParameter(CLUSTER_COLUMNS, true);
        this.addParameter(new HiddenInputLabel(CLUSTER_COLUMNS), clusterColumnsCheckBox, true);
        this.addParameter(COLUMN_DIST_METRIC, this.columnMetricComboBox, false);
        this.columnMetadataSelectorParameter = ClusteringActionUtil.addClusterOptionsParameters(this, GROUP_COLUMNS_ENABLED, GROUP_COLUMNS_BY, COLUMNS_CLUSTER_SELECTED_COLUMNS, CLUSTER_COLUMNS_ROW_SPACE, COLUMN_DIST_METRIC, clusterColumnsCheckBox, COLUMNS_CLUSTERS, COLUMNS_ITERATIONS);
        this.addParameter(COLUMNS_CLUSTERS, new TextFieldInputParameter("2-3"), false);
        this.addParameter(COLUMNS_ITERATIONS, new IntegerInputParameter(2000), false);
        this.getInputPanelBuilder().getFormBuilder().addSeparator();
        CheckBoxParameter clusterRowsCheckBox = new CheckBoxParameter(CLUSTER_ROWS, false);
        this.addParameter(new HiddenInputLabel(CLUSTER_ROWS), clusterRowsCheckBox, true);
        this.addParameter(ROW_DIST_METRIC, this.rowMetricComboBox, false);
        this.rowMetadataSelectorParameter = ClusteringActionUtil.addClusterOptionsParameters(this, GROUP_ROWS_ENABLED, GROUP_ROWS_BY, ROWS_CLUSTER_SELECTED_ROWS, CLUSTER_ROWS_COLUMN_SPACE, ROW_DIST_METRIC, clusterRowsCheckBox, ROWS_CLUSTERS, ROWS_ITERATIONS);
        this.addParameter(ROWS_CLUSTERS, new TextFieldInputParameter("2-3"), false);
        this.addParameter(ROWS_ITERATIONS, new IntegerInputParameter(2000), false);
    }

    @Override
    public boolean beforeWindowShown() {
        Project project = Application.getProject();
        String[] rowFields = MetadataUtil.getNames(project.getOriginalDataset().getRowMetadata()).toArray(new String[0]);
        Arrays.sort(rowFields, String.CASE_INSENSITIVE_ORDER);
        this.rowMetadataSelectorParameter.init(rowFields);
        String[] columnFields = MetadataUtil.getNames(project.getOriginalDataset().getColumnMetadata()).toArray(new String[0]);
        Arrays.sort(columnFields, String.CASE_INSENSITIVE_ORDER);
        this.columnMetadataSelectorParameter.init(columnFields);
        if (UserUtil.isBroadUser()) {
            try {
                ClusteringActionUtil.addMoleculeMetrics(this.rowMetricComboBox, project.getOriginalDataset().getRowMetadata());
                ClusteringActionUtil.addMoleculeMetrics(this.columnMetricComboBox, project.getOriginalDataset().getColumnMetadata());
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
        return true;
    }

    @Override
    protected void customizeMap(Project p, Map<String, Object> map) {
        boolean getSelectedRows;
        boolean getSelectedColumns;
        boolean bl = getSelectedColumns = (Boolean)map.get(COLUMNS_CLUSTER_SELECTED_COLUMNS) != false || (Boolean)map.get(CLUSTER_ROWS_COLUMN_SPACE) != false;
        if (getSelectedColumns) {
            map.put(SELECTED_COLUMN_INDICES_KEY, p.getColumnSelectionModel().getSelectedViewIndices());
        }
        boolean bl2 = getSelectedRows = (Boolean)map.get(ROWS_CLUSTER_SELECTED_ROWS) != false || (Boolean)map.get(CLUSTER_COLUMNS_ROW_SPACE) != false;
        if (getSelectedRows) {
            map.put(SELECTED_ROW_INDICES_KEY, p.getRowSelectionModel().getSelectedViewIndices());
        }
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        boolean columnsGrouped;
        Integer columnIterations = (Integer)map.get(COLUMNS_ITERATIONS);
        Integer rowsIterations = (Integer)map.get(ROWS_ITERATIONS);
        String columnClusterString = (String)map.get(COLUMNS_CLUSTERS);
        String rowClusterString = (String)map.get(ROWS_CLUSTERS);
        int[] numberOfColumnClusters = IOUtil.rangeToIntArray(columnClusterString);
        int[] numberOfRowClusters = IOUtil.rangeToIntArray(rowClusterString);
        BasicMapEntry rowMetricObject = (BasicMapEntry)map.get(ROW_DIST_METRIC);
        BasicMapEntry columnMetricObject = (BasicMapEntry)map.get(COLUMN_DIST_METRIC);
        boolean rowsGrouped = (Boolean)map.get(GROUP_ROWS_ENABLED);
        Object[] groupRowsByArray = (Object[])(rowsGrouped ? map.get(GROUP_ROWS_BY) : null);
        String[] groupRowsByFields = null;
        if (groupRowsByArray != null && groupRowsByArray.length > 0) {
            groupRowsByFields = new String[groupRowsByArray.length];
            for (int i = 0; i < groupRowsByArray.length; ++i) {
                groupRowsByFields[i] = (String)groupRowsByArray[i];
            }
        }
        Object[] groupColumnsByArray = (Object[])((columnsGrouped = ((Boolean)map.get(GROUP_COLUMNS_ENABLED)).booleanValue()) ? map.get(GROUP_COLUMNS_BY) : null);
        String[] groupColumnsByFields = null;
        if (groupColumnsByArray != null && groupColumnsByArray.length > 0) {
            groupColumnsByFields = new String[groupColumnsByArray.length];
            for (int i = 0; i < groupColumnsByArray.length; ++i) {
                groupColumnsByFields[i] = (String)groupColumnsByArray[i];
            }
        }
        Dataset filteredSortedDataset = DatasetUtil.shallowCopy((Dataset)map.get("dataset"));
        int[] rowsToCluster = (int[])map.remove(SELECTED_ROW_INDICES_KEY);
        int[] columnsToCluster = (int[])map.remove(SELECTED_COLUMN_INDICES_KEY);
        if (rowsToCluster != null && rowsToCluster.length == 0) {
            rowsToCluster = null;
        }
        if (columnsToCluster != null && columnsToCluster.length == 0) {
            columnsToCluster = null;
        }
        if (rowsToCluster != null && rowsToCluster.length <= 1) {
            throw new RuntimeException("Please select more than one row.");
        }
        if (columnsToCluster != null && columnsToCluster.length <= 1) {
            throw new RuntimeException("Please select more than one column.");
        }
        KMeansClusterer c = new KMeansClusterer();
        Map<Identifier, TIntArrayList> groupByToRowIndices = null;
        if (rowMetricObject != null) {
            Dataset selectedDataset = DatasetUtil.sliceView(filteredSortedDataset, rowsToCluster, (int[])((Boolean)map.get(CLUSTER_ROWS_COLUMN_SPACE) != false ? columnsToCluster : null));
            if (groupRowsByFields != null) {
                MetadataModel model = selectedDataset.getRowMetadata();
                Vector[] vectors = new Vector[groupRowsByFields.length];
                for (int j = 0; j < vectors.length; ++j) {
                    vectors[j] = model.get(groupRowsByFields[j]);
                }
                groupByToRowIndices = VectorUtil.createValuesToIndicesMap(vectors);
            }
            c.setIterations(rowsIterations);
            c.setDistanceFunction((DistanceFunction)rowMetricObject.getValue());
            ClusteringActionUtil.clusterRows(c, selectedDataset, numberOfRowClusters, groupByToRowIndices);
        }
        Map<Identifier, TIntArrayList> groupByToColumnIndices = null;
        if (columnMetricObject != null) {
            Dataset selectedDataset = DatasetUtil.sliceView(filteredSortedDataset, (int[])((Boolean)map.get(CLUSTER_COLUMNS_ROW_SPACE) != false ? rowsToCluster : null), columnsToCluster);
            if (groupColumnsByFields != null) {
                MetadataModel model = selectedDataset.getColumnMetadata();
                Vector[] vectors = new Vector[groupColumnsByFields.length];
                for (int j = 0; j < vectors.length; ++j) {
                    vectors[j] = model.get(groupColumnsByFields[j]);
                }
                groupByToColumnIndices = VectorUtil.createValuesToIndicesMap(vectors);
            }
            c.setIterations(columnIterations);
            c.setDistanceFunction((DistanceFunction)columnMetricObject.getValue());
            ClusteringActionUtil.clusterRows(c, DatasetUtil.transposeView(selectedDataset), numberOfColumnClusters, groupByToColumnIndices);
        }
        History history = this.getHistory(map);
        DefaultProject newProject = new DefaultProject(filteredSortedDataset, null, null, (Project)map.get("project"));
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode((Project)newProject, history, ClusteringActionUtil.createComponentCustomizer(groupByToRowIndices, groupByToColumnIndices));
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

