/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.BlockingThread;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class SaveDendrogramAction
extends AbstractAction {
    private boolean row;

    public SaveDendrogramAction(boolean row) {
        super("Save " + (row ? "Row" : "Column") + " Dendrogram" + "\u2026");
        this.row = row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Project project, File file) throws Exception {
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            if (this.row) {
                project.getRowDendrogram().save(os, "gtr");
            } else {
                project.getColumnDendrogram().save(os, "atr");
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {}
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        final File file = FileChooserUtil.showSaveDialog(UIUtil.getCurrentFrame(), new String[]{"." + (this.row ? "gtr" : "atr")}, null);
        if (file == null) {
            return;
        }
        final Project project = Application.getProject();
        new BlockingThread("Saving Dendrogram To " + file.getName(), true){

            @Override
            public void doInBackground() throws Exception {
                SaveDendrogramAction.this.save(project, file);
            }
        };
    }
}

