/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DockableFrameWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.VectorUtil;

public class SynergyCompoundHeatMaps {
    private String[] additionalFields;
    private String compound1Field;
    private String compound2Field;
    private String concentration1Field;
    private String concentration2Field;
    private Project synergyProject;
    private Project viabilityProject;

    public SynergyCompoundHeatMaps(String concentration1Field, String concentration2Field, String compound1Field, String compound2Field, String[] additionalFields, Project synergyProject, Project viabilityProject) {
        this.concentration1Field = concentration1Field;
        this.concentration2Field = concentration2Field;
        this.compound1Field = compound1Field;
        this.compound2Field = compound2Field;
        this.additionalFields = additionalFields;
        this.synergyProject = synergyProject;
        this.viabilityProject = viabilityProject;
    }

    public void createHeatMap(HeatMapPanel synergyyColorScheme, HeatMapPanel viabilityColorScheme, Dataset synergy, Dataset viability) {
        new PairedHeatMaps(synergyyColorScheme, viabilityColorScheme, synergy, viability);
    }

    public List<Dataset[]> createSynergyAndViabilityDatasets(int[] rowSelection, int[] columnSelection) {
        Dataset viability = DatasetUtil.sliceView(this.viabilityProject.getOriginalDataset(), null, columnSelection);
        Dataset synergy = DatasetUtil.sliceView(this.synergyProject.getOriginalDataset(), null, columnSelection);
        String[] vectorNames = new String[2 + this.additionalFields.length];
        vectorNames[0] = this.compound1Field;
        vectorNames[1] = this.compound2Field;
        String[] compound1Fields = new String[1 + this.additionalFields.length];
        compound1Fields[0] = this.compound1Field;
        String[] compound2Fields = new String[1 + this.additionalFields.length];
        compound2Fields[0] = this.compound2Field;
        int length = this.additionalFields.length;
        for (int i = 0; i < length; ++i) {
            vectorNames[i + 2] = this.additionalFields[i];
            compound1Fields[i + 1] = this.additionalFields[i];
            compound2Fields[i + 1] = this.additionalFields[i];
        }
        Dataset sel = DatasetUtil.sliceView(synergy, rowSelection, null);
        Set<Identifier> ids = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(sel.getRowMetadata(), vectorNames)).keySet();
        Map<Identifier, TIntArrayList> pairToRowIndices = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(synergy.getRowMetadata(), vectorNames));
        ArrayList<Dataset[]> results = new ArrayList<Dataset[]>();
        for (Identifier id : pairToRowIndices.keySet()) {
            if (!ids.contains(id)) continue;
            int[] rows = pairToRowIndices.get(id).toArray();
            Map<Object, Integer> concentration1ToIndex = IOUtil.buildIndexMap(Arrays.asList(VectorUtil.getValues(DatasetUtil.sliceView(synergy, rows, null).getRowMetadata().get(this.concentration1Field)).toArray()));
            Map<Object, Integer> concentration2ToIndex = IOUtil.buildIndexMap(Arrays.asList(VectorUtil.getValues(DatasetUtil.sliceView(synergy, rows, null).getRowMetadata().get(this.concentration2Field)).toArray()));
            int ncols = synergy.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                RowMajorArray2DDataset newSynergyDataset = new RowMajorArray2DDataset("synergy", concentration1ToIndex.size(), concentration2ToIndex.size());
                newSynergyDataset.setProperty("columnIndex", j);
                RowMajorArray2DDataset newViabilityDataset = new RowMajorArray2DDataset("viability", newSynergyDataset.getRowCount(), newSynergyDataset.getColumnCount());
                newSynergyDataset.setValue(0, 0, Float.NaN);
                newViabilityDataset.setValue(0, 0, Float.NaN);
                results.add(new Dataset[]{newSynergyDataset, newViabilityDataset});
                newViabilityDataset.setRowMetadata(newSynergyDataset.getRowMetadata());
                newViabilityDataset.setColumnMetadata(newSynergyDataset.getColumnMetadata());
                MetadataUtil.addVectors(synergy.getRowMetadata(), newSynergyDataset.getRowMetadata(), new String[]{this.compound1Field, this.concentration1Field});
                MetadataUtil.addVectors(synergy.getRowMetadata(), newSynergyDataset.getRowMetadata(), this.additionalFields);
                MetadataUtil.addVectors(synergy.getRowMetadata(), newSynergyDataset.getColumnMetadata(), new String[]{this.compound2Field, this.concentration2Field});
                MetadataUtil.addVectors(synergy.getRowMetadata(), newSynergyDataset.getColumnMetadata(), this.additionalFields);
                for (int rowIndex : rows) {
                    float s = synergy.getValue(rowIndex, j);
                    float v = viability.getValue(rowIndex, j);
                    Object concentration1Value = synergy.getRowMetadata().get(this.concentration1Field).getValue(rowIndex);
                    Object concentration2Value = synergy.getRowMetadata().get(this.concentration2Field).getValue(rowIndex);
                    int row = concentration1ToIndex.get(concentration1Value);
                    int col = concentration2ToIndex.get(concentration2Value);
                    newSynergyDataset.setValue(row, col, s);
                    newViabilityDataset.setValue(row, col, v);
                    for (String field : this.additionalFields) {
                        newSynergyDataset.getRowMetadata().get(field).setValue(row, synergy.getRowMetadata().get(field).getValue(rowIndex));
                        newSynergyDataset.getColumnMetadata().get(field).setValue(col, synergy.getRowMetadata().get(field).getValue(rowIndex));
                    }
                    newSynergyDataset.getRowMetadata().get(this.concentration1Field).setValue(row, synergy.getRowMetadata().get(this.concentration1Field).getValue(rowIndex));
                    newSynergyDataset.getRowMetadata().get(this.compound1Field).setValue(row, synergy.getRowMetadata().get(this.compound1Field).getValue(rowIndex));
                    newSynergyDataset.getColumnMetadata().get(this.concentration2Field).setValue(col, synergy.getRowMetadata().get(this.concentration2Field).getValue(rowIndex));
                    newSynergyDataset.getColumnMetadata().get(this.compound2Field).setValue(col, synergy.getRowMetadata().get(this.compound2Field).getValue(rowIndex));
                }
            }
        }
        return results;
    }

    public Project getSynergyProject() {
        return this.synergyProject;
    }

    private class PairedHeatMaps {
        private ChangeListener synergyColorSchemeChangeListener;
        private ChangeListener viabilityChangeListener;

        private PairedHeatMaps(final HeatMapPanel synergyHeatMap, final HeatMapPanel viabilityHeatMap, Dataset synergy, Dataset viability) {
            final ProjectGENEEResultTreeNode synergyNode = new ProjectGENEEResultTreeNode(new DefaultProject(synergy), null);
            final ProjectGENEEResultTreeNode viabilityNode = new ProjectGENEEResultTreeNode(new DefaultProject(viability), null);
            GENEEResultNodeGroup group = new GENEEResultNodeGroup();
            synergyNode.setGroup(group);
            viabilityNode.setGroup(group);
            group.setParentNode(synergyNode);
            group.addChild(viabilityNode);
            DockableFrameWindow synergyWindow = (DockableFrameWindow)Application.createViewWindow("Synergy", new GENEEWindowNotifier(){
                boolean initted;

                @Override
                public void notifyHidden() {
                }

                @Override
                public void notifyShowing() {
                    if (!this.initted) {
                        ((HeatMapPanel)synergyNode.getDisplayInfo().getComponent()).setColorScheme(synergyHeatMap.getColorScheme().copy());
                        this.initted = true;
                    }
                }
            });
            synergyWindow.setPreferredSize(new Dimension(Math.min(1000, UIUtil.getMaximumWindowSize().width), 300));
            synergyWindow.getContentPane().add(synergyNode.getDisplayInfo().getComponent());
            synergyWindow.setVisible(true);
            DockableFrameWindow viabilityWindow = (DockableFrameWindow)Application.createViewWindow("Viability", new GENEEWindowNotifier(){
                boolean initted;

                @Override
                public void notifyHidden() {
                }

                @Override
                public void notifyShowing() {
                    if (!this.initted) {
                        ((HeatMapPanel)viabilityNode.getDisplayInfo().getComponent()).setColorScheme(viabilityHeatMap.getColorScheme().copy());
                        this.initted = true;
                    }
                }
            });
            viabilityWindow.getContentPane().add(viabilityNode.getDisplayInfo().getComponent());
            viabilityWindow.setVisible(true);
            synergyWindow.getDockingManager().moveFrame(synergyWindow.getKey(), viabilityWindow.getKey(), 8);
            this.synergyColorSchemeChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatMapColorScheme copy = ((HeatMapColorScheme)e.getSource()).copy();
                    ((HeatMapPanel)synergyNode.getDisplayInfo().getComponent()).setColorScheme(copy);
                }
            };
            synergyHeatMap.getColorScheme().addChangeListener(this.synergyColorSchemeChangeListener);
            this.viabilityChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatMapColorScheme copy = ((HeatMapColorScheme)e.getSource()).copy();
                    ((HeatMapPanel)viabilityNode.getDisplayInfo().getComponent()).setColorScheme(copy);
                }
            };
            viabilityHeatMap.getColorScheme().addChangeListener(this.viabilityChangeListener);
        }
    }
}

