/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.dnd;

import com.community.xanadu.components.dnd.DnDGhostDialog;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import org.broadinstitute.genee.gui.UIUtil;

public class DndUtil {
    static DnDGhostDialog dialog;
    static boolean showTranslucentDialog;

    public static boolean isSupported(DropTargetDragEvent dtde, Class<?>[] allowableClasses) {
        try {
            Object td = dtde.getTransferable().getTransferData(new DataFlavor("application/x-java-jvm-local-objectref"));
            if (td != null) {
                for (Class<?> c : allowableClasses) {
                    if (!c.isAssignableFrom(td.getClass())) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void setDropEnabled(JComponent c, final Class<?>[] cl, final int dndConstants, final DropTargetListener dropCallback) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (dropCallback == null) {
            throw new NullPointerException("drop callback is null");
        }
        if (c instanceof JList) {
            ((JList)c).setDropMode(DropMode.ON_OR_INSERT);
        }
        new DropTarget(c, dndConstants, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (this.check(dtde)) {
                    dropCallback.dragEnter(dtde);
                }
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                dropCallback.dragExit(dte);
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                if (this.check(dtde)) {
                    dropCallback.dragOver(dtde);
                }
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    dropCallback.drop(dtde);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            private boolean check(DropTargetDragEvent dtde) {
                try {
                    if (DndUtil.isSupported(dtde, cl)) {
                        dtde.acceptDrag(dndConstants);
                        return true;
                    }
                    dtde.rejectDrag();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtde.rejectDrag();
                }
                return false;
            }
        }, true);
    }

    static void maybeInitDrag() {
        if (dialog == null) {
            UIUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    dialog = new DnDGhostDialog();
                }
            });
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.addDragSourceMotionListener(new DragSourceMotionListener(){

                @Override
                public void dragMouseMoved(DragSourceDragEvent dsde) {
                    if (dialog != null && showTranslucentDialog) {
                        if (dialog.containsImage()) {
                            Point p = (Point)dsde.getLocation().clone();
                            dialog.setDialogLocation(p);
                        } else {
                            dialog.hide();
                        }
                    }
                }
            });
        }
    }

    static {
        showTranslucentDialog = true;
    }
}

