/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.dnd;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.TransferableObject;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;
import org.broadinstitute.genee.table.DragTextIcon;

public class ListDndUtil {
    private static void addElement(ListModel listModel, Object element, int index) {
        if (listModel instanceof FilterableListModel) {
            ((FilterableListModel)((Object)listModel)).addElement(index, element);
        } else if (listModel instanceof DefaultListModel) {
            ((DefaultListModel)listModel).insertElementAt(element, index);
        }
    }

    private static void addElement(ListModel listModel, Object element) {
        if (listModel instanceof FilterableListModel) {
            ((FilterableListModel)((Object)listModel)).addElement(element);
        } else if (listModel instanceof DefaultListModel) {
            ((DefaultListModel)listModel).addElement(element);
        }
    }

    private static void removeElement(ListModel listModel, Object element) {
        if (listModel instanceof FilterableListModel) {
            ((FilterableListModel)((Object)listModel)).removeElement(element);
        } else if (listModel instanceof DefaultListModel) {
            ((DefaultListModel)listModel).removeElement(element);
        }
    }

    public static class ReorderOrMoveListElementsCallback
    implements DropTargetListener {
        private ListDropCallback listDropCallback;

        public ReorderOrMoveListElementsCallback(ListDropCallback listDropCallback) {
            this.listDropCallback = listDropCallback;
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            Object tmpTransferData = null;
            try {
                tmpTransferData = e.getTransferable().getTransferData(e.getCurrentDataFlavors()[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!(tmpTransferData instanceof ListTransferData)) {
                return;
            }
            Component destComponent = e.getDropTargetContext().getDropTarget().getComponent();
            ListTransferData listTransferData = (ListTransferData)tmpTransferData;
            Object[] selection = listTransferData.getSelectedValues();
            if (selection != null) {
                JList sourceList;
                ListModel sourceModel;
                JList list = (JList)destComponent;
                ListModel destModel = list.getModel();
                if (destModel == (sourceModel = (sourceList = listTransferData.getList()).getModel())) {
                    if (sourceModel instanceof FilterableListModel && !((FilterableListModel)((Object)sourceModel)).isSorted()) {
                        int i;
                        int index = list.locationToIndex(e.getLocation()) - selection.length + 1;
                        index = Math.max(0, index);
                        index = Math.min(((FilterableListModel)((Object)sourceModel)).getActualModel().getSize(), index);
                        for (i = 0; i < selection.length; ++i) {
                            ListDndUtil.removeElement(sourceModel, selection[i]);
                        }
                        for (i = 0; i < selection.length; ++i) {
                            ListDndUtil.addElement(destModel, selection[i], index);
                        }
                    }
                } else {
                    for (int i = 0; i < selection.length; ++i) {
                        ListDndUtil.removeElement(sourceModel, selection[i]);
                        ListDndUtil.addElement(destModel, selection[i]);
                    }
                }
                this.listDropCallback.dropNotify(sourceList, list, selection);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    public static class ListTransferHandler
    extends PatchedTransferHandler {
        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Icon getVisualRepresentation(Transferable t) {
            TransferableObject tt = (TransferableObject)t;
            Object[] selection = ((ListTransferData)tt.getData()).getSelectedValues();
            ArrayList<String> stringSelection = new ArrayList<String>();
            if (selection != null) {
                int size = selection.length;
                for (int i = 0; i < size; ++i) {
                    stringSelection.add(String.valueOf(selection[i]));
                }
            }
            return new DragTextIcon(stringSelection, false);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JList) {
                JList list = (JList)c;
                return new TransferableObject<ListTransferData>(new ListTransferData(list, list.getSelectedValues()));
            }
            return null;
        }
    }

    public static class ListTransferData
    implements Serializable {
        private JList list;
        private Object[] selectedValues;

        public ListTransferData(JList list, Object[] selectedValues) {
            this.list = list;
            this.selectedValues = selectedValues;
        }

        public JList getList() {
            return this.list;
        }

        public Object[] getSelectedValues() {
            return this.selectedValues;
        }
    }

    public static interface ListDropCallback {
        public void dropNotify(JList var1, JList var2, Object[] var3);
    }
}

