/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.dnd;

import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.table.DragTextIcon;
import org.broadinstitute.genee.table.HeatMapColumnTableModel;
import org.broadinstitute.genee.table.HeatMapDrag;
import org.broadinstitute.genee.table.HeatMapDragColumns;
import org.broadinstitute.genee.table.HeatMapDragRows;

public class TableDndUtil {
    public static void setDragEnabled(JTable table, boolean rows) {
        table.setDragEnabled(true);
        table.setTransferHandler(new TableTransferHandler(rows));
    }

    private static class TableTransferHandler
    extends PatchedTransferHandler {
        private boolean rowTable;

        public TableTransferHandler(boolean rows) {
            this.rowTable = rows;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Icon getVisualRepresentation(Transferable t) {
            HeatMapDrag tt = (HeatMapDrag)t;
            List<String> items = tt.getItems();
            return new DragTextIcon(items, tt instanceof HeatMapDragColumns);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                int counter;
                String fieldName;
                JTable table = (JTable)c;
                int[] indices = null;
                if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                    return null;
                }
                if (this.rowTable) {
                    fieldName = table.getColumnName(table.getSelectedColumn());
                    if (!table.getRowSelectionAllowed()) {
                        int rowCount = table.getRowCount();
                        indices = new int[rowCount];
                        for (counter = 0; counter < rowCount; ++counter) {
                            indices[counter] = counter;
                        }
                    } else {
                        indices = table.getSelectedRows();
                    }
                } else {
                    fieldName = ((HeatMapColumnTableModel)table.getModel()).getMetadataRowName(table.getSelectedRow());
                    if (!table.getColumnSelectionAllowed()) {
                        int colCount = table.getColumnCount();
                        indices = new int[colCount];
                        for (counter = 0; counter < colCount; ++counter) {
                            indices[counter] = counter;
                        }
                    } else {
                        indices = table.getSelectedColumns();
                    }
                }
                if (indices == null || indices.length == 0) {
                    return null;
                }
                int[] modelIndices = new int[indices.length];
                Project project = Application.getProject();
                if (this.rowTable) {
                    int length = indices.length;
                    for (int i = 0; i < length; ++i) {
                        modelIndices[i] = project.convertViewRowIndexToModel(indices[i]);
                    }
                    return new HeatMapDragRows(project, modelIndices, fieldName);
                }
                int length = indices.length;
                for (int i = 0; i < length; ++i) {
                    modelIndices[i] = project.convertViewColumnIndexToModel(indices[i]);
                }
                return new HeatMapDragColumns(project, modelIndices, fieldName);
            }
            return null;
        }
    }
}

