/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.grid;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.broadinstitute.genee.gui.TransferableObject;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.dnd.DragHelper;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class AttributesVerticalDragComponent {
    private Dataset dataset;
    private JPanel panel;
    private JScrollPane scrollPane;
    private boolean rows;

    public AttributesVerticalDragComponent(boolean rows) {
        this.rows = rows;
        this.panel = new JPanel();
        this.scrollPane = UIUtil.createNoBorderScrollPane(this.panel);
    }

    public Component getComponent() {
        return this.scrollPane;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
        this.rebuild();
    }

    private JComponent createDraggableComponent(final Vector column) {
        JLabel c = new JLabel(column.getName());
        new DragHelper(c, new PatchedTransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new TransferableObject<OrientedVector>(VectorUtil.asOrientedVector(column, AttributesVerticalDragComponent.this.rows));
            }
        }, 2);
        return c;
    }

    private void rebuild() {
        MetadataModel metadata = this.rows ? this.dataset.getRowMetadata() : this.dataset.getColumnMetadata();
        this.panel.removeAll();
        this.panel.setLayout((LayoutManager)new FormLayout("p", UIUtil.createStringForFormLayout("1px", "p", 1 + metadata.getMetadataCount())));
        CellConstraints cc = new CellConstraints();
        int formRowIndex = 3;
        List<String> names = MetadataUtil.getNames(metadata);
        int i = 0;
        while (i < names.size()) {
            this.panel.add((Component)this.createDraggableComponent(metadata.get(names.get(i))), cc.xy(1, formRowIndex));
            ++i;
            formRowIndex += 2;
        }
        this.panel.setMinimumSize(new Dimension());
    }
}

