/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.google.common.base.Supplier;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.CloseablePanelList;
import org.broadinstitute.genee.gui.parameters.DefaultSupplier;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Vector;

public abstract class AbstractComparisonInputList
implements InputParameter<Object[]> {
    CloseablePanelList closeablePanelList;
    private boolean initted;
    List<Supplier<Component>> supplierList = new ArrayList<Supplier<Component>>();
    private JPanel panel;
    Project project;

    public AbstractComparisonInputList() {
        this.closeablePanelList = new CloseablePanelList(){

            @Override
            protected void notifyAdded(Supplier<Component> c) {
                AbstractComparisonInputList.this.supplierList.add(c);
            }

            @Override
            protected void notifyDeleted(Supplier<Component> c) {
                AbstractComparisonInputList.this.supplierList.remove(c);
            }
        };
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.closeablePanelList, "Center");
        JButton addBtn = new JButton("Add Comparison");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComparisonInputList.this.closeablePanelList.addCloseable(AbstractComparisonInputList.this.createNewComponentSupplier());
            }
        });
        this.panel.add((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)addBtn), "South");
    }

    @Override
    public JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public Object[] getParameterValue() {
        if (!this.getJComponent().isEnabled()) {
            return new Vector[0];
        }
        Object[] results = new Object[this.supplierList.size()];
        for (int i = 0; i < this.supplierList.size(); ++i) {
            DefaultSupplier supplier = (DefaultSupplier)this.supplierList.get(i);
            results[i] = supplier.getValue();
        }
        return results;
    }

    public void init(Project project) {
        this.project = project;
        if (!this.initted) {
            this.initted = true;
            this.closeablePanelList.addCloseable(this.createNewComponentSupplier());
        }
    }

    @Override
    public void init(Object value) {
    }

    protected abstract Supplier<Component> createNewComponentSupplier();
}

