/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import javax.swing.JComponent;
import org.broadinstitute.genee.gui.parameters.CheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class MetadataCheckBoxListParameter
implements InputParameter<String[]> {
    private CheckBoxListParameter parameter = new CheckBoxListParameter();
    private Class<?> classFilter;
    private boolean rows;

    public MetadataCheckBoxListParameter(boolean rows, Class<?> classFilter) {
        this.rows = rows;
        this.classFilter = classFilter;
    }

    public void setSelection(Object[] values) {
        this.parameter.setSelection(values);
    }

    @Override
    public JComponent getJComponent() {
        return this.parameter.getJComponent();
    }

    @Override
    public String[] getParameterValue() {
        Object[] tmp = this.parameter.getParameterValue();
        String[] array = new String[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            array[i] = (String)tmp[i];
        }
        return array;
    }

    @Override
    public Class<?> getValueClass() {
        return String[].class;
    }

    @Override
    public void init(Object value) {
        Project p = (Project)value;
        if (p == null) {
            System.err.println("Project is null.");
            return;
        }
        MetadataModel m = this.rows ? p.getOriginalDataset().getRowMetadata() : p.getOriginalDataset().getColumnMetadata();
        m = this.classFilter == null ? m : MetadataUtil.getColumns(m, this.classFilter);
        this.parameter.init(MetadataUtil.getNames(m).toArray());
    }

    @Override
    public void setValueFromString(String string) {
        this.parameter.setValueFromString(string);
    }
}

