/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class MetadataComboBoxInputParameter
extends JComboBox
implements InputParameter<String> {
    protected boolean rows;
    private Class<?> classFilter = null;

    public MetadataComboBoxInputParameter(boolean rows) {
        this.rows = rows;
    }

    public MetadataComboBoxInputParameter(boolean rows, Class<?> classFilter) {
        this.rows = rows;
        this.classFilter = classFilter;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public String getParameterValue() {
        return (String)(this.isEnabled() ? this.getSelectedItem() : null);
    }

    public void setSelection(Object[] values) {
        if (values != null && values.length == 1) {
            this.setSelectedItem(values[0]);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.getItemCount()) {
            super.setSelectedIndex(index);
        }
    }

    @Override
    public Class<?> getValueClass() {
        return String.class;
    }

    @Override
    public void init(Object value) {
        Project p = (Project)value;
        if (p == null) {
            System.err.println("Project is null.");
            return;
        }
        Object selected = this.getSelectedItem();
        this.removeAllItems();
        this.addMetadata(this.rows ? p.getOriginalDataset().getRowMetadata() : p.getOriginalDataset().getColumnMetadata());
        if (selected != null) {
            this.setSelectedItem(selected);
        }
    }

    public void setClassFilter(Class<?> classFilter) {
        this.classFilter = classFilter;
    }

    public void setRows(boolean rows) {
        this.rows = rows;
    }

    @Override
    public void setValueFromString(String s) {
        this.setValueFromString(s, true);
    }

    public void setValueFromString(String s, boolean matchCase) {
        String itemText;
        int i;
        boolean found = false;
        if (!matchCase) {
            s = s.toLowerCase();
        }
        int cc = this.getItemCount();
        for (i = 0; i < cc; ++i) {
            itemText = Formatter.toString(this.getItemAt(i));
            if (!matchCase) {
                itemText = s.toLowerCase();
            }
            if (!s.equals(itemText)) continue;
            this.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            cc = this.getItemCount();
            for (i = 0; i < cc; ++i) {
                itemText = Formatter.toString(this.getItemAt(i));
                if (!matchCase) {
                    itemText = s.toLowerCase();
                }
                if (!s.contains(itemText)) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    private void addMetadata(MetadataModel m) {
        if (m != null) {
            MetadataModel filtered = this.classFilter == null ? m : MetadataUtil.getColumns(m, this.classFilter);
            int cols = filtered.getMetadataCount();
            for (int i = 0; i < cols; ++i) {
                this.addItem(filtered.getColumnName(i));
            }
        }
    }
}

