/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.scroll;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.gui.GENEEToolTipManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.scroll.ScrollBarUIHelper;
import org.broadinstitute.genee.gui.scroll.ScrollMouseHelper;
import org.broadinstitute.genee.gui.scroll.SearchScrollBarUI;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.QuickFilter;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class HorizontalScrollBarUIHelper
implements ScrollBarUIHelper {
    private List<Node> highlightedNodes;
    private Project project;
    private int[] selectedColumnIndices;
    private SelectionListener selectionListener;
    private SizesAndPositions sizesAndPositions;
    private ActionListener actionListener;
    private QuickFilter quickFilter;
    protected int[] highlightedColumnIndices;
    private MouseListener mouseListener;
    private float scale;
    private int offset;
    private int height;
    private JScrollBar scrollbar;
    private MouseMotionListener mouseMotionListener;

    public HorizontalScrollBarUIHelper(QuickFilter quickFilter, SizesAndPositions sizesAndPositions) {
        this.quickFilter = quickFilter;
        this.sizesAndPositions = sizesAndPositions;
    }

    @Override
    public void draw(Graphics g, int width, int height, int offset) {
        height -= 2;
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        g2.translate(0, 1);
        this.scale = (float)width / this.sizesAndPositions.getPosition(this.sizesAndPositions.getLength() - 1);
        this.offset = offset;
        this.height = height;
        if (this.selectedColumnIndices != null) {
            this.draw(g2, UIUtil.SELECTION_COLOR, this.selectedColumnIndices);
        }
        if (this.highlightedColumnIndices != null) {
            this.draw(g2, UIUtil.HIGHLIGHT_COLOR, this.highlightedColumnIndices);
        }
        this.drawHighlightedNodes((Graphics2D)g, width, height, offset);
        g2.setTransform(transform);
    }

    private int getIndex(MouseEvent e) {
        float pos2;
        float pos1 = ScrollMouseHelper.getLowerPositionForHorizontalScroll(e, this.scale, this.offset);
        int index = ScrollMouseHelper.binarySearch(this.sizesAndPositions, this.highlightedColumnIndices, pos1, (pos2 = ScrollMouseHelper.getUpperPositionForHorizontalScroll(e, this.scale, this.offset)) - pos1);
        if (index < 0) {
            index = ScrollMouseHelper.binarySearch(this.sizesAndPositions, this.selectedColumnIndices, pos1, pos2 - pos1);
        }
        return index;
    }

    @Override
    public void install(final JScrollBar scrollbar) {
        UIUtil.registerToolTip(scrollbar);
        this.project = this.quickFilter.getProject();
        this.scrollbar = scrollbar;
        this.selectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                HorizontalScrollBarUIHelper.access$002(HorizontalScrollBarUIHelper.this, HorizontalScrollBarUIHelper.this.project.getColumnSelectionModel().getSelectedViewIndices());
                scrollbar.repaint();
            }
        };
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HorizontalScrollBarUIHelper.this.project.getColumnSelectionModel().removeSelectionListener(HorizontalScrollBarUIHelper.this.selectionListener);
                HorizontalScrollBarUIHelper.this.project = HorizontalScrollBarUIHelper.this.quickFilter.getProject();
                HorizontalScrollBarUIHelper.this.project.getColumnSelectionModel().addSelectionListener(HorizontalScrollBarUIHelper.this.selectionListener);
                HorizontalScrollBarUIHelper.access$002(HorizontalScrollBarUIHelper.this, HorizontalScrollBarUIHelper.this.project.getColumnSelectionModel().getSelectedViewIndices());
                HorizontalScrollBarUIHelper.this.highlightedNodes = HorizontalScrollBarUIHelper.this.project.getHighlightedColumnDendrogramNodes();
                HorizontalScrollBarUIHelper.this.highlightedColumnIndices = HorizontalScrollBarUIHelper.this.quickFilter.getHighlightedIndices();
                scrollbar.repaint();
            }
        };
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JScrollPane sp;
                float pos1 = ScrollMouseHelper.getLowerPositionForHorizontalScroll(e, HorizontalScrollBarUIHelper.this.scale, HorizontalScrollBarUIHelper.this.offset);
                float pos2 = ScrollMouseHelper.getUpperPositionForHorizontalScroll(e, HorizontalScrollBarUIHelper.this.scale, HorizontalScrollBarUIHelper.this.offset);
                int index = ScrollMouseHelper.binarySearch(HorizontalScrollBarUIHelper.this.sizesAndPositions, HorizontalScrollBarUIHelper.this.highlightedColumnIndices, pos1, pos2 - pos1);
                int[] indices = HorizontalScrollBarUIHelper.this.highlightedColumnIndices;
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(HorizontalScrollBarUIHelper.this.sizesAndPositions, HorizontalScrollBarUIHelper.this.selectedColumnIndices, pos1, pos2 - pos1);
                    indices = HorizontalScrollBarUIHelper.this.selectedColumnIndices;
                }
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(HorizontalScrollBarUIHelper.this.highlightedNodes, pos1, pos2 - pos1);
                    indices = null;
                }
                if (index >= 0 && (sp = UIUtil.getScrollPane(scrollbar)) != null) {
                    int position = indices == null ? (int)(((Node)HorizontalScrollBarUIHelper.this.highlightedNodes.get(index)).getPosition() - HorizontalScrollBarUIHelper.this.sizesAndPositions.getSize()) : (int)HorizontalScrollBarUIHelper.this.sizesAndPositions.getPosition(indices[index]);
                    position = Math.max(0, position);
                    sp.getHorizontalScrollBar().setValue(position);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        this.mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                float pos1 = ScrollMouseHelper.getLowerPositionForHorizontalScroll(e, HorizontalScrollBarUIHelper.this.scale, HorizontalScrollBarUIHelper.this.offset);
                float pos2 = ScrollMouseHelper.getUpperPositionForHorizontalScroll(e, HorizontalScrollBarUIHelper.this.scale, HorizontalScrollBarUIHelper.this.offset);
                int[] indices = HorizontalScrollBarUIHelper.this.highlightedColumnIndices;
                int index = ScrollMouseHelper.binarySearch(HorizontalScrollBarUIHelper.this.sizesAndPositions, HorizontalScrollBarUIHelper.this.highlightedColumnIndices, pos1, pos2 - pos1);
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(HorizontalScrollBarUIHelper.this.sizesAndPositions, HorizontalScrollBarUIHelper.this.selectedColumnIndices, pos1, pos2 - pos1);
                    indices = HorizontalScrollBarUIHelper.this.selectedColumnIndices;
                }
                if (index >= 0) {
                    List<Map.Entry> entries = DatasetUtil.getToolTipText(HorizontalScrollBarUIHelper.this.project.getSortedFilteredDataset(), -1, indices[index], null, null);
                    scrollbar.putClientProperty(GENEEToolTipManager.KEY, entries);
                    scrollbar.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    scrollbar.putClientProperty(GENEEToolTipManager.KEY, null);
                    scrollbar.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        scrollbar.addMouseListener(this.mouseListener);
        scrollbar.addMouseMotionListener(this.mouseMotionListener);
        this.quickFilter.addActionListener(this.actionListener);
        this.project.getColumnSelectionModel().addSelectionListener(this.selectionListener);
    }

    public void setHighlightCategories(boolean highlight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uninstall() {
        this.scrollbar.removeMouseListener(this.mouseListener);
        this.scrollbar.removeMouseMotionListener(this.mouseMotionListener);
        this.quickFilter.removeActionListener(this.actionListener);
        this.project.getColumnSelectionModel().removeSelectionListener(this.selectionListener);
        UIUtil.unregisterToolTip(this.scrollbar);
    }

    protected void drawHighlightedNodes(Graphics2D g2, int width, int height, int offset) {
        if (this.highlightedNodes != null) {
            float scale = (float)width / this.sizesAndPositions.getPosition(this.sizesAndPositions.getLength() - 1);
            Paint paint = g2.getPaint();
            g2.setPaint(UIUtil.HIGHLIGHT_COLOR);
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.width = 1.8f;
            rect.height = height;
            for (Node node : this.highlightedNodes) {
                float xpix = node.getPosition();
                xpix = scale * xpix;
                rect.x = (xpix += (float)offset) - 1.0f;
                g2.fill(rect);
            }
            g2.setPaint(paint);
        }
    }

    private void draw(Graphics2D g, Color color, int[] indices) {
        Color oldColor = g.getColor();
        g.setColor(color);
        Rectangle2D.Float rect = new Rectangle2D.Float();
        rect.width = 1.8f;
        rect.height = this.height;
        for (int columnIndex : indices) {
            float xpix = this.sizesAndPositions.getPosition(columnIndex);
            xpix = this.scale * xpix;
            rect.x = (xpix += (float)this.offset) - 1.0f;
            g.fill(rect);
        }
        g.setColor(oldColor);
    }

    public static ScrollBarUI createScrollBarUI(QuickFilter quickFilter, SizesAndPositions sizesAndPositions) {
        return new SearchScrollBarUI(new HorizontalScrollBarUIHelper(quickFilter, sizesAndPositions));
    }

    static /* synthetic */ int[] access$002(HorizontalScrollBarUIHelper x0, int[] x1) {
        x0.selectedColumnIndices = x1;
        return x1;
    }
}

