/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.scroll;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.cmap.rankedlist.RankedListComponent;

public class RankedListVisibleIntervalDrawer
extends JPanel {
    private int barHeight = 4;
    private float centerPix;
    private ChangeListener changeListener;
    private boolean dragging;
    private int first = -1;
    private float firstPix;
    private int last = -1;
    private float lastPix;
    private float mousePressedFirstYPix;
    private int mousePressedY;
    private RankedListComponent rankedListView;
    private int rowIndex;
    private JScrollPane sp;
    private JTable table;
    private JViewport viewport;

    public RankedListVisibleIntervalDrawer(final JScrollPane sp, final RankedListComponent rankedListView, final JTable table) {
        this.table = table;
        this.sp = sp;
        this.viewport = sp.getViewport();
        this.rankedListView = rankedListView;
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = (JViewport)e.getSource();
                Rectangle viewRect = viewport.getViewRect();
                RankedListVisibleIntervalDrawer.this.first = table.rowAtPoint(new Point(0, viewRect.y));
                RankedListVisibleIntervalDrawer.this.last = table.rowAtPoint(new Point(0, viewRect.y + viewRect.height - 1));
                RankedListVisibleIntervalDrawer.this.repaint();
            }
        };
        this.setBackground(Color.WHITE);
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int position = table.getRowHeight() * rankedListView.pixToRankedListIndex(RankedListVisibleIntervalDrawer.this.rowIndex, e.getY());
                sp.getVerticalScrollBar().setValue(position);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (RankedListVisibleIntervalDrawer.this.isInsideThumb(e)) {
                    RankedListVisibleIntervalDrawer.this.mousePressedY = e.getY();
                    RankedListVisibleIntervalDrawer.this.mousePressedFirstYPix = rankedListView.rankedListIndexToPix(RankedListVisibleIntervalDrawer.this.rowIndex, RankedListVisibleIntervalDrawer.this.first);
                } else {
                    RankedListVisibleIntervalDrawer.this.mousePressedY = -1;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RankedListVisibleIntervalDrawer.this.mousePressedY = -1;
            }
        };
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (RankedListVisibleIntervalDrawer.this.mousePressedY != -1) {
                    RankedListVisibleIntervalDrawer.this.scrollTo(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (RankedListVisibleIntervalDrawer.this.isInsideThumb(e)) {
                    RankedListVisibleIntervalDrawer.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    RankedListVisibleIntervalDrawer.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.viewport.addChangeListener(this.changeListener);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, this.rankedListView.getPreferredSize().height);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.viewport.removeChangeListener(this.changeListener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.first == -1) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.firstPix = this.rankedListView.rankedListIndexToPix(this.rowIndex, this.first);
        this.lastPix = this.rankedListView.rankedListIndexToPix(this.rowIndex, this.last);
        this.centerPix = (this.firstPix + this.lastPix) / 2.0f;
        Rectangle2D.Float rect = new Rectangle2D.Float(2.0f, this.centerPix - (float)(this.barHeight / 2), this.getWidth() - 2, this.barHeight);
        g2.setColor(Color.DARK_GRAY);
        g2.fill(rect);
    }

    private boolean isInsideThumb(MouseEvent e) {
        return Math.abs((float)e.getY() - this.centerPix) <= 2.0f;
    }

    private void scrollTo(MouseEvent e) {
        float delta = e.getY() - this.mousePressedY;
        float ypix = this.mousePressedFirstYPix + delta;
        int position = this.table.getRowHeight() * this.rankedListView.pixToRankedListIndex(this.rowIndex, ypix);
        this.sp.getVerticalScrollBar().setValue(position);
    }
}

