/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.ibm.icu.text.NumberFormat;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.swing.JidePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.InputContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.SearchFieldSelectorPopupMenuCustomizer;

public abstract class AbstractQuickFilterPanel
extends QuickFilterField {
    private static GENEEWindow helpWindow;
    protected boolean caseSensitiveMenuItemsVisible = true;
    protected String defaultFilterColumnName = "All";
    protected boolean enableAndOrMenuItems = true;
    protected NumberFormat numberFormat = NumberFormat.getIntegerInstance();
    protected boolean orQuery = true;
    protected JMenuItem queryHelpMenuItem;
    protected int searchMode = 0;
    private JLabel searchResultsLabel;
    private boolean searchResultsRightOfTextField;

    public AbstractQuickFilterPanel() {
        this(true);
    }

    public AbstractQuickFilterPanel(boolean searchResultsRightOfTextField) {
        this.setHintText("Search");
        this.setFocusable(true);
        this.searchResultsRightOfTextField = searchResultsRightOfTextField;
        this.searchResultsLabel = new JLabel(" ");
        this.searchResultsLabel.setOpaque(false);
        this.searchResultsLabel.setFont(this.searchResultsLabel.getFont().deriveFont(this.searchResultsLabel.getFont().getSize2D() - 1.0f));
        this.setColumns(20);
        this.setCaseSensitive(false);
        this.setSearchingDelay(400);
        this.getTextField().setTransferHandler(new DefaultTransferHandler(this.getTextField().getTransferHandler()));
        this.queryHelpMenuItem = new JMenuItem("Search Help");
        this.queryHelpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractQuickFilterPanel.this.createHelpWindow();
                helpWindow.setVisible(true);
            }
        });
    }

    public JComponent getComponent() {
        JPanel panel;
        CellConstraints cc = new CellConstraints();
        if (this.searchResultsRightOfTextField) {
            panel = new JPanel((LayoutManager)new FormLayout("p, 1px, p, 1px", "p"));
            panel.add((Component)((Object)this), cc.xy(1, 1));
            panel.add((Component)this.searchResultsLabel, cc.xy(3, 1));
        } else {
            panel = new JPanel((LayoutManager)new FormLayout("p:grow:fill", "p, 2px, top:p:grow:fill, 2px"));
            panel.add((Component)((Object)this), cc.xy(1, 1));
            panel.add((Component)this.searchResultsLabel, cc.xy(1, 3));
        }
        return panel;
    }

    public String getDefaultFilterColumnName() {
        return this.defaultFilterColumnName;
    }

    public final String getResourceString(String s) {
        return GridResource.getResourceBundle((Locale)this.getLocale()).getString(s);
    }

    public String[] getSavedSearchNames() {
        Object[] names;
        Preferences p = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        p = p.node("saved.search");
        p = p.node(this.getSavedSearchKey());
        try {
            names = p.childrenNames();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            names = new String[]{};
        }
        Arrays.sort(names);
        return names;
    }

    public String getSearchingText() {
        if (this.getTextField() != null) {
            String str = this.getTextField().getText().trim();
            return str;
        }
        return "";
    }

    public int getSearchMode() {
        return this.searchMode;
    }

    public JLabel getSearchResultsLabel() {
        return this.searchResultsLabel;
    }

    public String getText() {
        String text = super.getText();
        if (text == null) {
            text = "";
        }
        return text.trim();
    }

    public boolean isOrQuery() {
        return this.orQuery;
    }

    public boolean isSearchAllFields() {
        return "All".equals(this.defaultFilterColumnName);
    }

    public final boolean requestFocusInWindow() {
        return this.getTextField().requestFocusInWindow();
    }

    public void saveSearch() {
        String name = UIUtil.showInputDialog((Component)((Object)this), "Please enter a name for this search", null);
        if (name != null && !name.equals("")) {
            Preferences p = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            p = p.node("saved.search");
            p = p.node(this.getSavedSearchKey());
            p = p.node(name);
            p.put("text", this.getTextField().getText().trim());
            p.put("search.field", this.defaultFilterColumnName);
            p.putInt("searchMode", this.searchMode);
            p.putBoolean("case.sensitive", this.isCaseSensitive());
            p.putBoolean("or", this.orQuery);
        }
    }

    public void setLabelText(String text) {
        this.searchResultsLabel.setText(text);
    }

    public void setSearchText(String text) {
        this.getTextField().setText(text);
        this.applyFilter(text);
    }

    protected void clearLabelText() {
        this.searchResultsLabel.setText(" ");
    }

    protected final JidePopupMenu createContextMenu() {
        JidePopupMenu popupmenu = new JidePopupMenu();
        this.customizeContextMenu(popupmenu);
        return popupmenu;
    }

    protected void createHelpWindow() {
        if (helpWindow == null) {
            helpWindow = Application.createDialog("Search Help");
            JEditorPane pane = new JEditorPane();
            pane.setEditable(false);
            pane.setContentType("text/html");
            try {
                pane.setPage(((Object)((Object)this)).getClass().getResource("/org/broadinstitute/genee/resources/query-help.html"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            helpWindow.getContentPane().add(UIUtil.createNoBorderScrollPane(pane));
            helpWindow.setSize(400, 500);
        }
    }

    protected final void customizeContextMenu(JidePopupMenu popupmenu) {
        String searchKey = this.getSavedSearchKey();
        if (searchKey != null) {
            String[] names;
            JMenu savedSearchesMenu = new JMenu("Saved Searches");
            for (final String name : names = this.getSavedSearchNames()) {
                JMenuItem menuItem = new JMenuItem(name);
                savedSearchesMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractQuickFilterPanel.this.loadSearch(name);
                    }
                });
            }
            if (savedSearchesMenu.getItemCount() > 0) {
                JMenuItem manageMenuItem = new JMenuItem("Manage\u2026");
                savedSearchesMenu.addSeparator();
                savedSearchesMenu.add(manageMenuItem);
                manageMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final DefaultListModel<String> listModel = new DefaultListModel<String>();
                        for (String name : names) {
                            listModel.addElement(name);
                        }
                        final JList list = new JList(listModel);
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.add(UIUtil.createNoBorderScrollPane(list));
                        JButton deleteButton = new JButton("Delete");
                        deleteButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Object[] selection = list.getSelectedValues();
                                if (selection != null) {
                                    for (Object sel : selection) {
                                        listModel.removeElement(sel);
                                        AbstractQuickFilterPanel.this.removeSearch((String)sel);
                                    }
                                }
                            }
                        });
                        panel.add((Component)UIUtil.buildOKBar(deleteButton), "South");
                        GENEEWindow dialog = Application.createDialog("Manage Saved Searches");
                        dialog.getContentPane().add(panel);
                        dialog.pack();
                        dialog.setVisible(true);
                    }
                });
                popupmenu.add((JMenuItem)savedSearchesMenu);
                popupmenu.addSeparator();
            }
        }
        final JRadioButtonMenuItem caseSensitiveMenuItem = new JRadioButtonMenuItem(this.getResourceString("Filter.caseSensitive.text"), this.isCaseSensitive());
        final JRadioButtonMenuItem ignoreCaseMenuItem = new JRadioButtonMenuItem(this.getResourceString("Filter.caseInsensitive.text"), !this.isCaseSensitive());
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem source = (JRadioButtonMenuItem)e.getSource();
                AbstractQuickFilterPanel.this.setCaseSensitive(source == caseSensitiveMenuItem);
                caseSensitiveMenuItem.setSelected(AbstractQuickFilterPanel.this.isCaseSensitive());
                ignoreCaseMenuItem.setSelected(!AbstractQuickFilterPanel.this.isCaseSensitive());
                AbstractQuickFilterPanel.this.applyFilter();
            }
        };
        ButtonGroup searchModeButtonGroup = new ButtonGroup();
        final JRadioButtonMenuItem searchModeContains = new JRadioButtonMenuItem("Contains", this.searchMode == 0);
        final JRadioButtonMenuItem searchModeExactMatch = new JRadioButtonMenuItem("Exact Match", this.searchMode == 3);
        ActionListener searchModeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == searchModeContains) {
                    AbstractQuickFilterPanel.this.searchMode = 0;
                } else if (e.getSource() == searchModeExactMatch) {
                    AbstractQuickFilterPanel.this.searchMode = 3;
                }
                AbstractQuickFilterPanel.this.applyFilter();
            }
        };
        searchModeContains.addActionListener(searchModeListener);
        searchModeExactMatch.addActionListener(searchModeListener);
        searchModeButtonGroup.add(searchModeContains);
        searchModeButtonGroup.add(searchModeExactMatch);
        popupmenu.add((JMenuItem)searchModeContains);
        popupmenu.add((JMenuItem)searchModeExactMatch);
        ButtonGroup bg = new ButtonGroup();
        bg.add(caseSensitiveMenuItem);
        bg.add(ignoreCaseMenuItem);
        if (this.caseSensitiveMenuItemsVisible) {
            popupmenu.addSeparator();
            popupmenu.add((JMenuItem)caseSensitiveMenuItem);
            popupmenu.add((JMenuItem)ignoreCaseMenuItem);
        }
        caseSensitiveMenuItem.addActionListener(l);
        ignoreCaseMenuItem.addActionListener(l);
        final JRadioButtonMenuItem orMenuItem = new JRadioButtonMenuItem("Match any search terms", this.isOrQuery());
        orMenuItem.setEnabled(this.enableAndOrMenuItems);
        final JRadioButtonMenuItem andMenuItem = new JRadioButtonMenuItem("Match all search terms", !this.isOrQuery());
        andMenuItem.setEnabled(this.enableAndOrMenuItems);
        l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem source = (JRadioButtonMenuItem)e.getSource();
                AbstractQuickFilterPanel.this.setOrQuery(source == orMenuItem);
                orMenuItem.setSelected(AbstractQuickFilterPanel.this.isOrQuery());
                andMenuItem.setSelected(!AbstractQuickFilterPanel.this.isOrQuery());
                AbstractQuickFilterPanel.this.applyFilter();
            }
        };
        bg = new ButtonGroup();
        bg.add(orMenuItem);
        bg.add(andMenuItem);
        popupmenu.addSeparator();
        popupmenu.add((JMenuItem)orMenuItem);
        popupmenu.add((JMenuItem)andMenuItem);
        orMenuItem.addActionListener(l);
        andMenuItem.addActionListener(l);
        popupmenu.addSeparator();
        ActionListener searchFieldActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractQuickFilterPanel.this.defaultFilterColumnName = AbstractQuickFilterPanel.this.getFilterColumnName((JRadioButtonMenuItem)e.getSource());
                ((JRadioButtonMenuItem)e.getSource()).setSelected(true);
                AbstractQuickFilterPanel.this.applyFilter();
            }
        };
        Collection<String> names = this.getAvailableFieldNames();
        if (names != null) {
            new SearchFieldSelectorPopupMenuCustomizer((JPopupMenu)popupmenu, names, searchFieldActionListener, this.defaultFilterColumnName);
        }
        popupmenu.add(this.queryHelpMenuItem);
    }

    protected abstract Collection<String> getAvailableFieldNames();

    protected String getFilterColumnName(JRadioButtonMenuItem btn) {
        return btn.getText();
    }

    protected abstract String getSavedSearchKey();

    protected void setCaseSensitiveMenuItemsVisible(boolean b) {
        this.caseSensitiveMenuItemsVisible = b;
    }

    protected void setEnableAndOrMenuItems(boolean enableAndOrMenuItems) {
        this.enableAndOrMenuItems = enableAndOrMenuItems;
    }

    protected void setLabelText(int matches, int available) {
        this.setLabelText(this.numberFormat.format((long)matches) + " in " + this.numberFormat.format((long)available));
    }

    protected void setOrQuery(boolean orQuery) {
        this.orQuery = orQuery;
    }

    private void loadSearch(String name) {
        Preferences p = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        p = p.node("saved.search");
        p = p.node(this.getSavedSearchKey());
        p = p.node(name);
        String text = p.get("text", "");
        this.defaultFilterColumnName = p.get("search.field", this.defaultFilterColumnName);
        this.searchMode = p.getInt("searchMode", this.searchMode);
        this.setCaseSensitive(p.getBoolean("case.sensitive", this.isCaseSensitive()));
        this.orQuery = p.getBoolean("or", this.orQuery);
        this.setSearchText(text);
    }

    private void removeSearch(String name) {
        Preferences p = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        p = p.node("saved.search");
        p = p.node(this.getSavedSearchKey());
        p = p.node(name);
        try {
            p.removeNode();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private static class DefaultTransferHandler
    extends TransferHandler
    implements UIResource {
        private TransferHandler delegate;

        public DefaultTransferHandler(TransferHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.delegate.canImport(comp, transferFlavors);
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) throws IllegalStateException {
            this.delegate.exportToClipboard(comp, clipboard, action);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return this.delegate.getSourceActions(c);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            DataFlavor flavor;
            if (comp instanceof JTextComponent && (flavor = this.getFlavor(t.getTransferDataFlavors())) != null) {
                InputContext ic = comp.getInputContext();
                if (ic != null) {
                    ic.endComposition();
                }
                try {
                    String data = (String)t.getTransferData(flavor);
                    data = data.replaceAll("\\[", "\\\\[");
                    data = data.replaceAll("\\]", "\\\\]");
                    ((JTextComponent)comp).replaceSelection(data);
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return false;
        }

        private DataFlavor getFlavor(DataFlavor[] flavors) {
            if (flavors != null) {
                for (DataFlavor flavor : flavors) {
                    if (!flavor.equals(DataFlavor.stringFlavor)) continue;
                    return flavor;
                }
            }
            return null;
        }
    }
}

