/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.table.HeatMapRowTableModel;

public class AlignedNumberCellRenderer
extends DefaultTableCellRenderer {
    private StringBuilder sb = new StringBuilder();

    public AlignedNumberCellRenderer() {
        this.setHorizontalTextPosition(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        HeatMapRowTableModel.VectorDataWrapper wrapper = (HeatMapRowTableModel.VectorDataWrapper)value;
        value = wrapper.object;
        Integer maxIntegerDigits = (Integer)wrapper.vector.getProperty("maxIntegerDigits");
        this.setHorizontalTextPosition(2);
        this.setText(value == null ? "" : this.pad(Formatter.toString(value), maxIntegerDigits == null ? -1 : maxIntegerDigits));
        return this;
    }

    private String pad(String s, int maxIntegerDigits) {
        if (maxIntegerDigits == -1) {
            return s;
        }
        int index = s.indexOf(46);
        if (index == -1) {
            index = s.length();
        }
        this.sb.setLength(0);
        int size = maxIntegerDigits - index + 1;
        for (int i = 0; i < size; ++i) {
            this.sb.append(" ");
        }
        this.sb.append(s);
        return this.sb.toString();
    }
}

