/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.JMenuItem;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.NewSetInputDialog;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CreateSetFromSelectionMenuItem
extends JMenuItem {
    public CreateSetFromSelectionMenuItem(final boolean row, String text, final HeatMapPanel heatMapPanel) {
        super(text);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = row ? heatMapPanel.getProject().getRowSelectionModel().getSelectedViewIndices() : heatMapPanel.getProject().getColumnSelectionModel().getSelectedViewIndices();
                Project project = heatMapPanel.getProject();
                Callable<Void> c = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        return null;
                    }
                };
                String setName = "Set 1";
                MetadataModel metadata = row ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
                MetadataModel categoryColumns = MetadataUtil.getCategoryColumns(metadata);
                if (categoryColumns.getMetadataCount() > 0) {
                    setName = "Set " + (1 + VectorUtil.getValues(categoryColumns.get(categoryColumns.getMetadataCount() - 1)).size());
                }
                new NewSetInputDialog(project, indices, row, setName, c);
            }
        });
        if (row) {
            heatMapPanel.getProject().getRowSelectionModel().addSelectionListener(new SelectionListener(){

                @Override
                public void valueChanged(SelectionEvent e) {
                    CreateSetFromSelectionMenuItem.this.setEnabled(heatMapPanel.getProject().getRowSelectionModel().getSelectionCount() > 0);
                }
            });
        } else {
            SelectionListener columnSelectionListener = new SelectionListener(){

                @Override
                public void valueChanged(SelectionEvent e) {
                    CreateSetFromSelectionMenuItem.this.setEnabled(heatMapPanel.getProject().getColumnSelectionModel().getSelectionCount() > 0);
                }
            };
            heatMapPanel.getProject().getColumnSelectionModel().addSelectionListener(columnSelectionListener);
        }
        this.setEnabled(false);
    }
}

