/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.heatmap.ElementEvent;
import org.broadinstitute.genee.heatmap.ElementSelectionListener;
import org.broadinstitute.genee.heatmap.ElementSelectionModel;

public class DefaultElementSelectionModel
implements ElementSelectionModel {
    private EventListenerList listenerList = new UniqueEventListenerList();
    private List<MatrixElement> selectedModelElementIndices = new ArrayList<MatrixElement>();

    @Override
    public void addElementSelectionListener(ElementSelectionListener l) {
        this.listenerList.add(ElementSelectionListener.class, l);
    }

    @Override
    public List<MatrixElement> getSelectedElements() {
        return this.selectedModelElementIndices;
    }

    @Override
    public void removeElementSelectionListener(ElementSelectionListener l) {
        this.listenerList.remove(ElementSelectionListener.class, l);
    }

    @Override
    public void setSelectedElements(List<MatrixElement> elements) {
        this.selectedModelElementIndices = elements;
        this.notifyHeatMapElementListeners();
    }

    private void notifyHeatMapElementListeners() {
        List<MatrixElement> selectedModelElementIndices = this.selectedModelElementIndices;
        Object[] listeners = this.listenerList.getListenerList();
        ElementEvent event = new ElementEvent(this, selectedModelElementIndices);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ElementSelectionListener.class) continue;
            ((ElementSelectionListener)listeners[i + 1]).elementSelectionChanged(event);
        }
    }
}

