/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.heatmap.ColorSupplier;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.DiscreteColorSupplier;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeLegend;
import org.broadinstitute.genee.heatmap.Log2Dataset;
import org.broadinstitute.genee.heatmap.MultiGradientColorSupplier;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.math.adjust.LogScaleUnivariateFunction;
import org.broadinstitute.genee.math.stat.function.MedianAbsoluteDeviation;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetSeriesAdapter;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class DefaultHeatMapColorScheme
implements HeatMapColorScheme {
    private ColorSupplier colorSupplier;
    private String customName;
    private transient Dataset dataset;
    private transient String datasetName;
    private boolean discrete;
    private float globalMax = Float.NaN;
    private float globalMin = Float.NaN;
    private transient HeatMapColorSchemeLegend legend;
    private Set<ChangeListener> listeners = new LinkedHashSet<ChangeListener>();
    private boolean logScale;
    private Color missingColor = Color.LIGHT_GRAY;
    private Set<DefaultElementPainter.Condition> conditions = new LinkedHashSet<DefaultElementPainter.Condition>();
    private transient Project project;
    private transient ProjectListener projectListener;
    private boolean relative;
    private float rowNormalizedMax = 3.0f;
    private float rowNormalizedMin = -3.0f;
    private int rowScalingMode = 2;
    private RowStats rowStats;
    private String separateColorSchemesForColumnMetadataField;
    private HashMap<Object, RowStats> valueToRowStats;
    private Vector vector;

    public DefaultHeatMapColorScheme() {
        this(true, Float.NaN, Float.NaN);
    }

    public DefaultHeatMapColorScheme(float min, float max) {
        this(false, min, max);
    }

    private DefaultHeatMapColorScheme(boolean relative, float min, float max) {
        this.relative = relative;
        this.globalMin = min;
        this.globalMax = max;
        this.colorSupplier = new MultiGradientColorSupplier();
        this.colorSupplier.setMax(max);
        this.colorSupplier.setMin(min);
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                DefaultHeatMapColorScheme.this.updateDataset();
            }
        };
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void addCondition(DefaultElementPainter.Condition p) {
        this.conditions.add(p);
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public boolean containsConditions() {
        return this.conditions.size() > 0;
    }

    @Override
    public HeatMapColorScheme copy() {
        DefaultHeatMapColorScheme colorScheme = new DefaultHeatMapColorScheme();
        colorScheme.colorSupplier = !this.isDiscrete() ? new MultiGradientColorSupplier() : new DiscreteColorSupplier();
        colorScheme.relative = this.isRelative();
        colorScheme.separateColorSchemesForColumnMetadataField = this.getSeparateColorSchemesForColumnMetadataField();
        colorScheme.rowScalingMode = this.getRowScalingMode();
        colorScheme.missingColor = this.getMissingColor();
        colorScheme.globalMin = this.getGlobalMin();
        colorScheme.globalMax = this.getGlobalMax();
        colorScheme.rowNormalizedMin = this.getRowNormalizedMin();
        colorScheme.rowNormalizedMax = this.getRowNormalizedMax();
        colorScheme.logScale = this.isLogScale();
        colorScheme.datasetName = this.getDatasetName();
        colorScheme.updateGlobalMin();
        colorScheme.updateGlobalMax();
        colorScheme.setColors(this.getColors(), this.getFractions());
        for (DefaultElementPainter.Condition c : this.conditions) {
            colorScheme.conditions.add(c.copy());
        }
        return colorScheme;
    }

    @Override
    public void dispose() {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.listeners.toArray(new ChangeListener[0]);
    }

    @Override
    public Collection<DefaultElementPainter.Condition> getConditions(int row, int column) {
        ArrayList<DefaultElementPainter.Condition> passed = new ArrayList<DefaultElementPainter.Condition>();
        for (DefaultElementPainter.Condition c : this.conditions) {
            if (!c.isEnabled() || !c.apply(row, column)) continue;
            passed.add(c);
        }
        return passed;
    }

    @Override
    public Color getColor(int row, int column, float value) {
        if (Float.isNaN(value)) {
            return this.missingColor;
        }
        if (this.logScale) {
            value = LogScaleUnivariateFunction.log2(value);
        }
        if (this.relative) {
            RowStats rowStats = this.separateColorSchemesForColumnMetadataField != null ? this.valueToRowStats.get(this.vector.getValue(column)) : this.rowStats;
            rowStats.maybeUpdate(row);
            if (this.rowScalingMode != 2) {
                this.colorSupplier.setMin(this.rowNormalizedMin);
                this.colorSupplier.setMax(this.rowNormalizedMax);
            } else if (this.rowScalingMode == 2) {
                this.colorSupplier.setMin(rowStats.rowCachedMin);
                this.colorSupplier.setMax(rowStats.rowCachedMax);
            }
            if (this.rowScalingMode == 3) {
                value -= rowStats.standardDeviation.getMean();
                value /= rowStats.rowScalingCachedStdev;
            } else if (this.rowScalingMode == 4) {
                value -= rowStats.medianAbsoluteDeviation.getMedian();
                value /= rowStats.rowScalingCachedMAD;
            }
        }
        return this.colorSupplier.getColor(row, column, value);
    }

    @Override
    public Color[] getColors() {
        return this.colorSupplier.getColors();
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public float[] getFractions() {
        return this.colorSupplier.getFractions();
    }

    @Override
    public float getGlobalMax() {
        return this.globalMax;
    }

    @Override
    public float getGlobalMin() {
        return this.globalMin;
    }

    @Override
    public HeatMapColorSchemeLegend getLegend() {
        if (this.legend == null) {
            this.legend = new HeatMapColorSchemeLegend(this);
        }
        return this.legend;
    }

    @Override
    public float getMax() {
        float max;
        if (this.relative) {
            if (this.getRowScalingMode() == 2) {
                return 1.0f;
            }
            max = this.getRowNormalizedMax();
        } else {
            max = this.colorSupplier.getMax();
        }
        return max;
    }

    @Override
    public float getMin() {
        float min;
        if (this.relative) {
            if (this.getRowScalingMode() == 2) {
                return -1.0f;
            }
            min = this.getRowNormalizedMin();
        } else {
            min = this.colorSupplier.getMin();
        }
        return min;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColor;
    }

    @Override
    public String getName() {
        if (this.customName != null) {
            return this.customName;
        }
        return this.relative ? "relative" : "global";
    }

    @Override
    public Collection<DefaultElementPainter.Condition> getPredicateAndShapes() {
        return this.conditions;
    }

    @Override
    public float getRowNormalizedMax() {
        return this.rowNormalizedMax;
    }

    @Override
    public float getRowNormalizedMin() {
        return this.rowNormalizedMin;
    }

    @Override
    public int getRowScalingMode() {
        return this.rowScalingMode;
    }

    @Override
    public String getSeparateColorSchemesForColumnMetadataField() {
        return this.separateColorSchemesForColumnMetadataField;
    }

    @Override
    public boolean isDiscrete() {
        return this.discrete;
    }

    @Override
    public boolean isLogScale() {
        return this.logScale;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void removeCondition(DefaultElementPainter.Condition p) {
        this.conditions.remove(p);
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setColors(Color[] colors) {
        float[] fractions = new float[colors.length];
        float step = 1.0f / (float)(colors.length - 1);
        float f = 0.0f;
        for (int i = 0; i < colors.length; ++i) {
            fractions[i] = f;
            f += step;
        }
        this.setColors(colors, fractions);
        this.notifyListeners();
    }

    @Override
    public void setColors(Color[] colors, float[] fractions) {
        this.colorSupplier.setPaint(fractions, colors);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setDiscrete(boolean discrete) {
        if (this.discrete != discrete) {
            this.discrete = discrete;
            ColorSupplier oldColorSupplier = this.colorSupplier;
            ColorSupplier newColorSupplier = discrete ? new DiscreteColorSupplier() : new MultiGradientColorSupplier();
            newColorSupplier.setMin(oldColorSupplier.getMin());
            newColorSupplier.setMax(oldColorSupplier.getMax());
            newColorSupplier.setPaint(oldColorSupplier.getFractions(), oldColorSupplier.getColors());
            this.colorSupplier = newColorSupplier;
            this.updateDataset();
            this.repaintLegend();
            this.notifyListeners();
        }
    }

    @Override
    public void setGlobalMax(float globalMax) {
        this.globalMax = globalMax;
        if (!this.relative) {
            this.colorSupplier.setMax(globalMax);
        }
        this.notifyListeners();
    }

    @Override
    public void setGlobalMin(float value) {
        this.globalMin = value;
        if (!this.relative) {
            this.colorSupplier.setMin(this.globalMin);
        }
        this.notifyListeners();
    }

    @Override
    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setMissingColor(Color missingColor) {
        this.missingColor = missingColor;
        this.notifyListeners();
    }

    @Override
    public void setName(String name) {
        this.customName = name;
        this.notifyListeners();
    }

    @Override
    public void setProject(Project p) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = p;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
        } else {
            System.out.println("Project is null.");
        }
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setRelative(boolean relative) {
        this.relative = relative;
        if (this.dataset != null) {
            this.updateGlobalMin();
            this.updateGlobalMax();
        }
        this.notifyListeners();
    }

    @Override
    public void setRowNormalizedMax(float rowNormalizedMax) {
        this.rowNormalizedMax = rowNormalizedMax;
        this.colorSupplier.setMax(rowNormalizedMax);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setRowNormalizedMin(float rowNormalizedMin) {
        this.rowNormalizedMin = rowNormalizedMin;
        this.colorSupplier.setMin(rowNormalizedMin);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setRowScalingMode(int mode) {
        this.rowScalingMode = mode;
        this.colorSupplier.setMin(this.rowNormalizedMin);
        this.colorSupplier.setMax(this.rowNormalizedMax);
        this.repaintLegend();
        this.notifyListeners();
    }

    @Override
    public void setSeparateColorSchemesForColumnMetadataField(String separateColorSchemesForColumnMetadataField) {
        this.separateColorSchemesForColumnMetadataField = separateColorSchemesForColumnMetadataField;
        this.updateDataset();
        this.notifyListeners();
    }

    protected void repaintLegend() {
        if (this.legend != null) {
            this.legend.revalidate();
            this.legend.repaint();
        }
    }

    protected void updateGlobalMax() {
        if (this.relative) {
            return;
        }
        if (Float.isNaN(this.globalMax) && this.dataset != null) {
            this.globalMax = DatasetUtil.max(this.dataset);
        }
        this.colorSupplier.setMax(this.globalMax);
        this.repaintLegend();
    }

    protected void updateGlobalMin() {
        if (this.relative) {
            return;
        }
        if (Float.isNaN(this.globalMin) && this.dataset != null) {
            this.globalMin = DatasetUtil.min(this.dataset);
        }
        this.colorSupplier.setMin(this.globalMin);
        this.repaintLegend();
    }

    private Dataset getDataset(boolean full) {
        Dataset dataset = null;
        if (this.project != null) {
            Dataset dataset2 = dataset = full ? this.project.getOriginalDataset() : this.project.getSortedFilteredDataset();
            if (this.datasetName != null) {
                dataset = new DatasetSeriesAdapter(dataset, DatasetUtil.getSeriesIndex(dataset, this.datasetName));
            }
            if (this.logScale) {
                dataset = new Log2Dataset(dataset);
            }
        }
        return dataset;
    }

    private void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void updateDataset() {
        if (this.project != null) {
            this.dataset = this.getDataset(false);
            this.valueToRowStats = new HashMap();
            this.vector = this.dataset.getColumnMetadata().get(this.separateColorSchemesForColumnMetadataField);
            if (this.vector == null) {
                this.rowStats = new RowStats(this.dataset, null);
                this.valueToRowStats.put(null, this.rowStats);
            } else {
                Map valueToIndices = VectorUtil.createValueToIndicesMap(this.vector);
                for (Object value : valueToIndices.keySet()) {
                    this.valueToRowStats.put(value, new RowStats(this.dataset, valueToIndices.get(value).toArray()));
                }
            }
            Dataset tmp = this.project.getSortedFilteredDataset();
            Iterator<Object> i$ = this.conditions.iterator();
            while (i$.hasNext()) {
                DefaultElementPainter.Condition c;
                int index = DatasetUtil.getSeriesIndex(tmp, (c = (DefaultElementPainter.Condition)i$.next()).getDatasetName());
                c.setDataset(index == -1 ? tmp : new DatasetSeriesAdapter(tmp, index));
            }
            this.updateGlobalMin();
            this.updateGlobalMax();
        }
    }

    public static HeatMapColorScheme load(String name, Class<?> c) {
        Preferences prefs = Preferences.userNodeForPackage(c);
        Preferences p = prefs.node("color.scheme");
        p = p.node(name);
        DefaultHeatMapColorScheme cs = new DefaultHeatMapColorScheme();
        cs.relative = p.getBoolean("relative", true);
        cs.rowScalingMode = p.getInt("rowScalingMode", 2);
        try {
            cs.missingColor = ImageUtil.decodeColor(p.get("missingColor", ""));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        cs.globalMin = p.getFloat("customGlobalMin", cs.globalMin);
        cs.globalMax = p.getFloat("customGlobalMax", cs.globalMax);
        cs.rowNormalizedMin = p.getFloat("rowStdevMin", cs.rowNormalizedMin);
        cs.rowNormalizedMax = p.getFloat("rowStdevMax", cs.rowNormalizedMax);
        cs.discrete = p.getBoolean("discrete", false);
        int fractionsLength = p.getInt("n.fractions", 0);
        float[] fractions = new float[fractionsLength];
        for (int i = 0; i < fractions.length; ++i) {
            fractions[i] = p.getFloat("fraction" + i, fractions[i]);
        }
        int colorsLength = p.getInt("n.colors", 0);
        Color[] colors = new Color[colorsLength];
        for (int i = 0; i < colors.length; ++i) {
            try {
                colors[i] = ImageUtil.decodeColor(p.get("color" + i, ""));
                continue;
            }
            catch (NumberFormatException nfe) {
                colors[i] = Color.RED;
            }
        }
        cs.setDiscrete(cs.discrete);
        cs.colorSupplier.setPaint(fractions, colors);
        cs.updateGlobalMin();
        cs.updateGlobalMax();
        return cs;
    }

    public static void save(HeatMapColorScheme colorScheme, String name, Class<?> c) {
        Preferences prefs = Preferences.userNodeForPackage(c);
        Preferences p = prefs.node("color.scheme");
        p = p.node(name);
        p.putBoolean("relative", colorScheme.isRelative());
        p.putInt("rowScalingMode", colorScheme.getRowScalingMode());
        p.put("missingColor", ImageUtil.toString(colorScheme.getMissingColor()));
        p.putFloat("customGlobalMin", colorScheme.getGlobalMin());
        p.putFloat("customGlobalMax", colorScheme.getGlobalMax());
        p.putFloat("rowStdevMin", colorScheme.getRowNormalizedMin());
        p.putFloat("rowStdevMax", colorScheme.getRowNormalizedMax());
        float[] fractions = colorScheme.getFractions();
        p.putInt("n.fractions", fractions.length);
        for (int i = 0; i < fractions.length; ++i) {
            p.putFloat("fraction" + i, fractions[i]);
        }
        Color[] colors = colorScheme.getColors();
        p.putInt("n.colors", colors.length);
        for (int i = 0; i < colors.length; ++i) {
            p.put("color" + i, ImageUtil.toString(colors[i]));
        }
    }

    private class RowStats {
        private transient float cachedRow = -1.0f;
        private transient DatasetRowView datasetRowView;
        private transient MedianAbsoluteDeviation medianAbsoluteDeviation = new MedianAbsoluteDeviation();
        private transient float rowCachedMax;
        private transient float rowCachedMin;
        private transient float rowScalingCachedMAD;
        private transient float rowScalingCachedStdev;
        private transient StandardDeviation standardDeviation = new StandardDeviation();

        private RowStats(Dataset dataset, int[] columnIndices) {
            this.datasetRowView = new DatasetRowView(dataset, columnIndices);
        }

        public void maybeUpdate(int row) {
            if (this.cachedRow != (float)row) {
                this.cachedRow = row;
                this.datasetRowView.setIndex(row);
                if (DefaultHeatMapColorScheme.this.rowScalingMode == 3) {
                    this.rowScalingCachedStdev = this.standardDeviation.evaluate(this.datasetRowView);
                } else if (DefaultHeatMapColorScheme.this.rowScalingMode == 4) {
                    this.rowScalingCachedMAD = this.medianAbsoluteDeviation.evaluate(this.datasetRowView);
                } else {
                    this.rowCachedMax = -3.4028235E38f;
                    this.rowCachedMin = Float.MAX_VALUE;
                    int ncols = this.datasetRowView.size();
                    for (int j = 0; j < ncols; ++j) {
                        float d = this.datasetRowView.getValue(j);
                        if (Float.isNaN(d)) continue;
                        this.rowCachedMax = d > this.rowCachedMax ? d : this.rowCachedMax;
                        this.rowCachedMin = d < this.rowCachedMin ? d : this.rowCachedMin;
                    }
                    if (this.rowCachedMin == this.rowCachedMax) {
                        this.rowCachedMin -= 1.0f;
                    }
                }
            }
        }
    }
}

