/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;

public class EffectsPanel
extends JPanel {
    private float alpha = 1.0f;
    private Animator animator;
    private float scale = 1.0f;

    public void fadeInOut(final ActionListener l) {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = new Animator(2000, new TimingTarget(){
            private boolean halfway = false;

            @Override
            public void begin() {
            }

            @Override
            public void end() {
                EffectsPanel.this.alpha = 1.0f;
                EffectsPanel.this.repaint();
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float f) {
                if (f > 0.5f) {
                    EffectsPanel.this.alpha = f;
                    if (!this.halfway) {
                        l.actionPerformed(new ActionEvent(this, 1001, null));
                        this.halfway = true;
                    }
                } else {
                    EffectsPanel.this.alpha = 1.0f - f;
                }
                EffectsPanel.this.repaint();
            }
        });
        this.animator.start();
    }

    public void grow() {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = new Animator(2000, new TimingTarget(){

            @Override
            public void begin() {
            }

            @Override
            public void end() {
                EffectsPanel.this.scale = 1.0f;
                EffectsPanel.this.repaint();
            }

            @Override
            public void repeat() {
            }

            @Override
            public void timingEvent(float f) {
                EffectsPanel.this.scale = f;
                EffectsPanel.this.repaint();
            }
        });
        this.animator.setInterpolator(new SplineInterpolator(1.0f, 0.0f, 0.0f, 1.0f));
        this.animator.start();
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    protected void paintComponent(Graphics g) {
        float scale;
        super.paintComponent(g);
        float alpha = this.alpha;
        if (alpha != 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        if ((scale = this.scale) != 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(0, 0, this.getWidth(), 0);
            }
            g2.setClip(clip.x, clip.y, clip.width, (int)((float)this.getHeight() * scale));
        }
    }
}

