/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

class FontSizeTableCellRenderer
extends DefaultTableCellRenderer {
    protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Font cachedFont;

    FontSizeTableCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color fg = null;
        Color bg = null;
        if (isSelected) {
            super.setForeground(fg == null ? table.getSelectionForeground() : fg);
            super.setBackground(bg == null ? table.getSelectionBackground() : bg);
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        Font font = table.getFont();
        if (font.getSize() > 16) {
            if (this.cachedFont == null || this.cachedFont.getSize() != 16) {
                this.cachedFont = font.deriveFont(16.0f);
            }
            font = this.cachedFont;
        } else if (font.getSize() > table.getRowHeight()) {
            int rowHeight = table.getRowHeight();
            if (this.cachedFont == null || this.cachedFont.getSize() != rowHeight) {
                this.cachedFont = font.deriveFont(rowHeight);
            }
            font = this.cachedFont;
        }
        this.setFont(font);
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(this.getNoFocusBorder());
        }
        this.setValue(value);
        return this;
    }

    private Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return this.SAFE_NO_FOCUS_BORDER;
        }
        return this.noFocusBorder;
    }
}

