/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.chart.ConditionalDrawingOptionsPanel;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.DiscreteColorSupplier;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeSupplier;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.LinearGradientChooserPanel;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

public class HeatMapColorSchemeOptionsPanel
implements ActionListener {
    private static ArrayList<PredefinedColorScheme> PREDEFINED_SCHEMES;
    private JComboBox colorByDatasetComboBox;
    private JCheckBox discreteCheckBox;
    private JLabel discreteDetailsLabel;
    private JRadioButton globalColorButton;
    private LinearGradientChooserPanel gradientChooserPanel;
    private HeatMapPanel heatMapPanel;
    private JCheckBox logScaleCheckBox;
    private EditColorButton missingColorButton;
    private JRadioButton relativeColorButton;
    private JCheckBox scaleColumnsSeparatelyCheckBox;
    private MetadataComboBoxInputParameter scaleColumnsSeparatelyField;
    private JRadioButton scaleUsingRowMinMax;
    private boolean showMissingColor = true;
    private boolean showPredefined = true;
    private boolean showRelativeSettings = true;
    private ThumbDataListener thumbDataListener;
    private String title = "Color Settings";
    private JRadioButton zMADButton;
    private JRadioButton zScoreButton;
    private JComboBox rowValueChooser;
    private JComboBox rowFieldChooser;

    public HeatMapColorSchemeOptionsPanel(HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
    }

    private void setCurrentValue() {
        Object value = this.rowValueChooser.getSelectedItem();
        ((HeatMapColorSchemeSupplier)this.heatMapPanel.getColorScheme()).setCurrentValue(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCurrentValue();
        if (e.getSource() == this.relativeColorButton || e.getSource() == this.globalColorButton) {
            boolean relative = e.getSource() == this.relativeColorButton;
            this.heatMapPanel.getColorScheme().setRelative(relative);
        } else if (e.getSource() == this.missingColorButton) {
            this.heatMapPanel.getColorScheme().setMissingColor(this.missingColorButton.getColor());
        } else if (e.getSource() == this.zScoreButton) {
            this.heatMapPanel.getColorScheme().setRowScalingMode(3);
        } else if (e.getSource() == this.scaleUsingRowMinMax) {
            this.heatMapPanel.getColorScheme().setRowScalingMode(2);
        } else if (e.getSource() == this.zMADButton) {
            this.heatMapPanel.getColorScheme().setRowScalingMode(4);
        } else if (e.getSource() == this.logScaleCheckBox) {
            this.heatMapPanel.getColorScheme().setLogScale(this.logScaleCheckBox.isSelected());
        } else if (e.getSource() == this.discreteCheckBox) {
            this.heatMapPanel.getColorScheme().setDiscrete(this.discreteCheckBox.isSelected());
            this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
            this.heatMapPanel.invalidateImage();
            this.discreteDetailsLabel.setVisible(this.discreteCheckBox.isSelected());
        } else if (e.getSource() == this.colorByDatasetComboBox) {
            String name = (String)this.colorByDatasetComboBox.getSelectedItem();
            this.heatMapPanel.getColorScheme().setDatasetName(name);
        } else if (e.getSource() == this.scaleColumnsSeparatelyCheckBox) {
            this.scaleColumnsSeparatelyField.setEnabled(this.scaleColumnsSeparatelyCheckBox.isEnabled() && this.scaleColumnsSeparatelyCheckBox.isSelected());
            this.heatMapPanel.getColorScheme().setSeparateColorSchemesForColumnMetadataField(this.scaleColumnsSeparatelyField.getParameterValue());
        } else if (e.getSource() == this.scaleColumnsSeparatelyField) {
            this.heatMapPanel.getColorScheme().setSeparateColorSchemesForColumnMetadataField(this.scaleColumnsSeparatelyField.getParameterValue());
        } else if (e.getSource() == this.rowValueChooser) {
            this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
            this.configureValues(false);
        } else if (e.getSource() == this.rowFieldChooser) {
            String field = (String)(this.rowFieldChooser.getSelectedIndex() > 0 ? this.rowFieldChooser.getSelectedItem() : null);
            ((HeatMapColorSchemeSupplier)this.heatMapPanel.getColorScheme()).setSeparateColorSchemesForRowMetadataField(field);
            this.updateRowValueChooser();
            this.configureValues(false);
        }
        this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
        this.enableComponents();
        this.heatMapPanel.invalidateImage();
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                UIUtil.setChildrenEnabledRecursively(this, enabled);
                UIUtil.setChildrenEnabledRecursively(HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel, enabled);
            }
        };
        final FormBuilder formBuilder = new FormBuilder(panel);
        formBuilder.addSeparator("Dataset");
        formBuilder.addLabel("Color:");
        this.colorByDatasetComboBox = UIUtil.createComboBox();
        UIUtil.rebuildDatasetCombobox(this.heatMapPanel.getProject(), this.colorByDatasetComboBox);
        formBuilder.add(this.colorByDatasetComboBox);
        formBuilder.nextRow();
        JButton btn = new JButton("Conditional Rendering\u2026");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = new JDialog(UIUtil.getCurrentFrame());
                dialog.setModal(true);
                dialog.setTitle("Conditional Rendering");
                dialog.getContentPane().add(new ConditionalDrawingOptionsPanel(HeatMapColorSchemeOptionsPanel.this.heatMapPanel));
                dialog.setSize(500, 500);
                dialog.show();
            }
        });
        formBuilder.addFirstColumn(btn);
        formBuilder.addSeparator("Tracks");
        formBuilder.addLabel("Separate color scheme for row annotation field:");
        this.rowFieldChooser = UIUtil.createComboBox();
        formBuilder.add(this.rowFieldChooser);
        formBuilder.nextRow();
        this.rowValueChooser = UIUtil.createComboBox();
        formBuilder.addLabel("Row annotation value:");
        formBuilder.add(this.rowValueChooser);
        formBuilder.addSeparator(this.title);
        if (this.showRelativeSettings) {
            formBuilder.addLabel("Color scheme:");
            this.relativeColorButton = new JRadioButton("Relative");
            formBuilder.add(this.relativeColorButton);
            this.globalColorButton = new JRadioButton("Global");
            formBuilder.nextSmallRow();
            formBuilder.add(this.globalColorButton);
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.relativeColorButton);
            bg1.add(this.globalColorButton);
        }
        this.gradientChooserPanel = new LinearGradientChooserPanel(){

            @Override
            public float max() {
                return FloatListStatUtils.max(DatasetUtil.asFloatList(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getProject().getOriginalDataset()));
            }

            @Override
            public float min() {
                return FloatListStatUtils.min(DatasetUtil.asFloatList(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getProject().getOriginalDataset()));
            }

            @Override
            public float percentile(int p) {
                return FloatListStatUtils.percentile(DatasetUtil.asFloatList(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getProject().getOriginalDataset()), p);
            }
        };
        this.gradientChooserPanel.setPreUpdateColorSchemeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorSchemeOptionsPanel.this.setCurrentValue();
            }
        });
        this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
        this.thumbDataListener = new ThumbDataListener(){

            public void positionChanged(ThumbDataEvent e) {
                this.update();
            }

            public void thumbAdded(ThumbDataEvent e) {
                this.update();
            }

            public void thumbRemoved(ThumbDataEvent e) {
                this.update();
            }

            public void update() {
                HeatMapColorSchemeOptionsPanel.this.setCurrentValue();
                LinearGradientChooserPanel.FractionColorPair[] pairs = HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.getFractionColorPairs();
                float[] fractions = new float[pairs.length];
                Color[] colors = new Color[pairs.length];
                for (int i = 0; i < fractions.length; ++i) {
                    fractions[i] = pairs[i].getFraction();
                    colors[i] = pairs[i].getColor();
                }
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setColors(colors, fractions);
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
            }

            public void valueChanged(ThumbDataEvent e) {
                this.update();
            }
        };
        this.gradientChooserPanel.addThumbDataListener(this.thumbDataListener);
        formBuilder.nextRow();
        formBuilder.add(this.gradientChooserPanel);
        formBuilder.nextRow();
        if (this.showMissingColor) {
            this.missingColorButton = new EditColorButton(this.heatMapPanel.getColorScheme().getMissingColor());
            this.missingColorButton.setColor(this.heatMapPanel.getColorScheme().getMissingColor());
            formBuilder.addLabel("Missing color:");
            formBuilder.add(this.missingColorButton);
        }
        formBuilder.nextRow();
        this.logScaleCheckBox = new JCheckBox("Log scale", false);
        formBuilder.addSpanned(this.logScaleCheckBox);
        this.discreteCheckBox = new JCheckBox("Discrete colors", false);
        formBuilder.nextRow();
        formBuilder.addSpanned(this.discreteCheckBox);
        this.discreteDetailsLabel = UIUtil.createSmallLabel("Intervals include right end point and exclude left end point except for the lowest interval");
        this.discreteDetailsLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        formBuilder.nextRowNoSpace();
        formBuilder.addSpanned(this.discreteDetailsLabel);
        if (this.showRelativeSettings) {
            formBuilder.addSeparator("Relative Settings");
            ButtonGroupHelper bg = new ButtonGroupHelper();
            this.zScoreButton = bg.createRadioButton("Subtract row mean, divide by row standard deviation", this.heatMapPanel.getColorScheme().getRowScalingMode() == 3);
            this.zMADButton = bg.createRadioButton("Subtract row median, divide by row median absolute deviation", this.heatMapPanel.getColorScheme().getRowScalingMode() == 3);
            this.scaleUsingRowMinMax = bg.createRadioButton("Row minimum and row maximum", this.heatMapPanel.getColorScheme().getRowScalingMode() == 2);
            this.scaleColumnsSeparatelyCheckBox = new JCheckBox("Scale columns separately by:");
            formBuilder.addFirstColumn(this.scaleColumnsSeparatelyCheckBox);
            this.scaleColumnsSeparatelyField = new MetadataComboBoxInputParameter(false);
            formBuilder.add(this.scaleColumnsSeparatelyField);
            formBuilder.nextRow();
            formBuilder.addLabel("Color values using:");
            formBuilder.add(this.scaleUsingRowMinMax);
            formBuilder.nextSmallRow();
            formBuilder.add(this.zScoreButton);
            formBuilder.nextSmallRow();
            formBuilder.add(this.zMADButton);
        }
        if (this.showPredefined) {
            formBuilder.addSeparator("Predefined Color Schemes");
            formBuilder.nextRow();
            final JButton saveBtn = new JButton("Save Current Settings\u2026");
            formBuilder.add(saveBtn);
            formBuilder.nextRow();
            final JComboBox saveColorSchemesComboBox = UIUtil.createComboBox();
            this.populateSavedColorSchemes(saveColorSchemesComboBox);
            formBuilder.addLabel("Predefined Schemes:");
            CellConstraints cc = new CellConstraints();
            JPanel predefPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout("left:p", 3), "p"));
            predefPanel.add((Component)saveColorSchemesComboBox, cc.xy(1, 1));
            final JButton loadBtn = new JButton("Load");
            final JButton deleteBtn = new JButton("Delete");
            ActionListener btnListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == saveBtn) {
                        String name = UIUtil.showInputDialog(formBuilder.getPanel(), "Please enter a name", "");
                        if (name != null) {
                            DefaultHeatMapColorScheme.save(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme(), name, HeatMapColorScheme.class);
                            saveColorSchemesComboBox.addItem(name);
                        }
                        HeatMapColorSchemeOptionsPanel.this.populateSavedColorSchemes(saveColorSchemesComboBox);
                    } else if (e.getSource() == loadBtn) {
                        HeatMapColorSchemeOptionsPanel.this.setCurrentValue();
                        int index = saveColorSchemesComboBox.getSelectedIndex();
                        if (index < PREDEFINED_SCHEMES.size()) {
                            ((PredefinedColorScheme)PREDEFINED_SCHEMES.get(index)).load(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme());
                            HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setHeatMapColorScheme(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme());
                        } else {
                            HeatMapColorScheme savedScheme = DefaultHeatMapColorScheme.load((String)saveColorSchemesComboBox.getSelectedItem(), HeatMapColorScheme.class);
                            ((HeatMapColorSchemeSupplier)HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme()).setColorScheme(savedScheme);
                            HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setHeatMapColorScheme(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme());
                        }
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
                    } else if (e.getSource() == deleteBtn) {
                        Preferences prefs = Preferences.userNodeForPackage(HeatMapColorScheme.class);
                        Preferences node = prefs.node("color.scheme");
                        String name = (String)saveColorSchemesComboBox.getSelectedItem();
                        node = node.node(name);
                        try {
                            node.removeNode();
                            saveColorSchemesComboBox.removeItem(name);
                        }
                        catch (BackingStoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    loadBtn.setEnabled(saveColorSchemesComboBox.getItemCount() > 0);
                    deleteBtn.setEnabled(saveColorSchemesComboBox.getSelectedIndex() > PREDEFINED_SCHEMES.size());
                    HeatMapColorSchemeOptionsPanel.this.configureValues(true);
                }
            };
            saveColorSchemesComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    deleteBtn.setEnabled(saveColorSchemesComboBox.getSelectedIndex() >= PREDEFINED_SCHEMES.size());
                }
            });
            loadBtn.setEnabled(saveColorSchemesComboBox.getItemCount() > 0);
            deleteBtn.setEnabled(false);
            loadBtn.addActionListener(btnListener);
            deleteBtn.addActionListener(btnListener);
            saveBtn.addActionListener(btnListener);
            predefPanel.add((Component)loadBtn, cc.xy(3, 1));
            predefPanel.add((Component)deleteBtn, cc.xy(5, 1));
            formBuilder.add(predefPanel);
        }
        if (this.heatMapPanel.getColorScheme() != null) {
            this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
        }
        if (this.showRelativeSettings && this.heatMapPanel.getColorScheme() != null) {
            this.relativeColorButton.setSelected(this.heatMapPanel.getColorScheme().isRelative());
            this.globalColorButton.setSelected(!this.heatMapPanel.getColorScheme().isRelative());
            this.relativeColorButton.addActionListener(this);
            this.globalColorButton.addActionListener(this);
            this.scaleColumnsSeparatelyCheckBox.addActionListener(this);
            this.scaleColumnsSeparatelyField.addActionListener(this);
            this.zScoreButton.addActionListener(this);
            this.scaleUsingRowMinMax.addActionListener(this);
            this.zMADButton.addActionListener(this);
        }
        if (this.showMissingColor) {
            this.missingColorButton.addActionListener(this);
        }
        this.logScaleCheckBox.addActionListener(this);
        this.colorByDatasetComboBox.addActionListener(this);
        this.discreteCheckBox.addActionListener(this);
        this.rowValueChooser.addActionListener(this);
        this.rowFieldChooser.addActionListener(this);
        this.enableComponents();
        return formBuilder.getPanel();
    }

    public void setShowMissingColor(boolean showMissingColor) {
        this.showMissingColor = showMissingColor;
    }

    public void setShowPredefined(boolean showPredefined) {
        this.showPredefined = showPredefined;
    }

    public void setShowRelativeSettings(boolean showRelativeSettings) {
        this.showRelativeSettings = showRelativeSettings;
    }

    private void updateRowValueChooser() {
        Object selectedValue = this.rowValueChooser.getSelectedItem();
        this.rowValueChooser.removeAllItems();
        String field = ((HeatMapColorSchemeSupplier)this.heatMapPanel.getColorScheme()).getSeparateColorSchemesForRowMetadataField();
        Vector vector = this.heatMapPanel.getProject().getOriginalDataset().getRowMetadata().get(field);
        if (vector != null) {
            Set values = VectorUtil.getValues(vector);
            for (Object val : values) {
                this.rowValueChooser.addItem(val);
            }
        }
        this.rowValueChooser.setSelectedItem(selectedValue);
    }

    void configureValues(boolean rebuild) {
        this.gradientChooserPanel.removeThumbDataListener(this.thumbDataListener);
        if (this.heatMapPanel.getColorScheme() != null) {
            if (rebuild) {
                this.rowFieldChooser.removeAllItems();
                List<String> names = MetadataUtil.getNames(this.heatMapPanel.getProject().getOriginalDataset().getRowMetadata());
                Collections.sort(names);
                this.rowFieldChooser.addItem("(None)");
                for (String name : names) {
                    this.rowFieldChooser.addItem(name);
                }
                this.rowFieldChooser.setSelectedItem(((HeatMapColorSchemeSupplier)this.heatMapPanel.getColorScheme()).getSeparateColorSchemesForRowMetadataField());
                this.updateRowValueChooser();
                this.scaleColumnsSeparatelyCheckBox.setSelected(this.heatMapPanel.getColorScheme().getSeparateColorSchemesForColumnMetadataField() != null);
                this.scaleColumnsSeparatelyField.init(this.heatMapPanel.getProject());
                this.scaleColumnsSeparatelyField.setEnabled(this.scaleColumnsSeparatelyCheckBox.isSelected());
                this.scaleColumnsSeparatelyField.setSelectedItem(this.heatMapPanel.getColorScheme().getSeparateColorSchemesForColumnMetadataField());
                this.colorByDatasetComboBox.removeActionListener(this);
                UIUtil.rebuildDatasetCombobox(this.heatMapPanel.getProject(), this.colorByDatasetComboBox);
                this.colorByDatasetComboBox.setSelectedItem(this.heatMapPanel.getColorScheme().getDatasetName());
                this.colorByDatasetComboBox.addActionListener(this);
            }
            this.globalColorButton.setSelected(!this.heatMapPanel.getColorScheme().isRelative());
            this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
            this.relativeColorButton.setSelected(this.heatMapPanel.getColorScheme().isRelative());
            this.scaleUsingRowMinMax.setSelected(this.heatMapPanel.getColorScheme().getRowScalingMode() == 2);
            this.zScoreButton.setSelected(this.heatMapPanel.getColorScheme().getRowScalingMode() == 3);
            this.zMADButton.setSelected(this.heatMapPanel.getColorScheme().getRowScalingMode() == 4);
            if (this.showMissingColor) {
                this.missingColorButton.setColor(this.heatMapPanel.getColorScheme().getMissingColor());
            }
            this.logScaleCheckBox.setSelected(this.heatMapPanel.getColorScheme().isLogScale());
            this.discreteCheckBox.setSelected(this.heatMapPanel.getColorScheme().isDiscrete());
            this.discreteDetailsLabel.setVisible(this.discreteCheckBox.isSelected());
            this.gradientChooserPanel.setHeatMapColorScheme(this.heatMapPanel.getColorScheme());
            this.enableComponents();
        }
        this.gradientChooserPanel.addThumbDataListener(this.thumbDataListener);
    }

    private void enableComponents() {
        if (this.heatMapPanel.getColorScheme() != null && this.showRelativeSettings) {
            this.zScoreButton.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
            this.scaleUsingRowMinMax.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
            this.zMADButton.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
            this.scaleColumnsSeparatelyCheckBox.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
            this.scaleColumnsSeparatelyField.setEnabled(this.scaleColumnsSeparatelyCheckBox.isEnabled() && this.scaleColumnsSeparatelyCheckBox.isSelected());
        }
    }

    private void populateSavedColorSchemes(JComboBox saveColorSchemesComboBox) {
        saveColorSchemesComboBox.removeAllItems();
        for (PredefinedColorScheme item : PREDEFINED_SCHEMES) {
            saveColorSchemesComboBox.addItem(item.longName);
        }
        try {
            String[] keys;
            Preferences prefs = Preferences.userNodeForPackage(HeatMapColorScheme.class);
            Preferences node = prefs.node("color.scheme");
            for (String key : keys = node.childrenNames()) {
                saveColorSchemesComboBox.addItem(key);
            }
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    public static void loadPredefinedColorScheme(HeatMapColorScheme s, String shortName) {
        for (PredefinedColorScheme item : PREDEFINED_SCHEMES) {
            if (!shortName.equals(item.shortName)) continue;
            item.load(s);
            break;
        }
    }

    private static void createPredefinedColorSchemes() {
        PREDEFINED_SCHEMES = new ArrayList();
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("non-ratio", "Default color scheme for non-ratio data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setRelative(true);
                cs.setRowScalingMode(2);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("ratio", "Default color scheme for ratio data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setRelative(false);
                cs.setGlobalMin(-3.0f);
                cs.setGlobalMax(3.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("cn", "Default color scheme for copy number data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setRelative(false);
                cs.setGlobalMin(-1.5f);
                cs.setGlobalMax(1.5f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("z-score", "Default color scheme for z-scored data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setRelative(false);
                cs.setGlobalMin(-10.0f);
                cs.setGlobalMax(10.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE, Color.RED}, new float[]{0.0f, 0.4f, 0.6f, 1.0f});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("jet", "Jet color scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(true);
                Color[] colors = DiscreteColorSupplier.createJetColors();
                float[] fractions = DiscreteColorSupplier.createFractions(colors);
                cs.setColors(colors, fractions);
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("binary", "Binary scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(true);
                cs.setRelative(false);
                cs.setGlobalMin(0.0f);
                cs.setGlobalMax(1.0f);
                Color[] colors = new Color[]{Color.WHITE, QualitativeColorSchemes.getTenColor(0)};
                float[] fractions = DiscreteColorSupplier.createFractions(colors);
                cs.setColors(colors, fractions);
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("synergy", "Synergy scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setRelative(false);
                cs.setGlobalMin(0.2f);
                cs.setGlobalMax(0.7f);
                cs.setColors(new Color[]{Color.WHITE, Color.RED}, new float[]{0.0f, 1.0f});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("viability", "Viability scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setRelative(false);
                cs.setGlobalMax(100.0f);
                cs.setGlobalMin(0.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE});
            }
        });
    }

    static {
        HeatMapColorSchemeOptionsPanel.createPredefinedColorSchemes();
    }

    private static abstract class PredefinedColorScheme {
        private String longName;
        private String shortName;

        public PredefinedColorScheme(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }

        public abstract void load(HeatMapColorScheme var1);

        public String toString() {
            return this.longName;
        }
    }
}

