/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;

public class HeatMapColorSchemeSupplier
implements HeatMapColorScheme {
    private HeatMapColorScheme currentColorScheme;
    private Set<ChangeListener> listeners = new LinkedHashSet<ChangeListener>();
    private Project project;
    private ProjectListener projectListener;
    private Map<Object, HeatMapColorScheme> rowValueToColorScheme = new HashMap<Object, HeatMapColorScheme>();
    private String separateColorSchemesForRowMetadataField;
    private Object value;
    private Vector vector;
    private Object firstValue;

    public HeatMapColorSchemeSupplier() {
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                HeatMapColorSchemeSupplier.this.updateDataset();
            }
        };
        this.currentColorScheme = new DefaultHeatMapColorScheme();
        this.rowValueToColorScheme.put(null, this.currentColorScheme);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void addCondition(DefaultElementPainter.Condition p) {
        this.currentColorScheme.addCondition(p);
        this.notifyListeners();
    }

    @Override
    public boolean containsConditions() {
        for (HeatMapColorScheme cs : this.rowValueToColorScheme.values()) {
            if (!cs.containsConditions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public HeatMapColorScheme copy() {
        HeatMapColorSchemeSupplier supplier = new HeatMapColorSchemeSupplier();
        for (Object value : this.rowValueToColorScheme.keySet()) {
            supplier.rowValueToColorScheme.put(value, this.rowValueToColorScheme.get(value).copy());
        }
        supplier.currentColorScheme = supplier.rowValueToColorScheme.get(null);
        supplier.separateColorSchemesForRowMetadataField = this.separateColorSchemesForRowMetadataField;
        return supplier;
    }

    @Override
    public void dispose() {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        for (HeatMapColorScheme cs : this.rowValueToColorScheme.values()) {
            cs.dispose();
        }
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.listeners.toArray(new ChangeListener[0]);
    }

    @Override
    public Color getColor(int row, int column, float val) {
        Object tmp;
        if (this.separateColorSchemesForRowMetadataField != null && this.value != (tmp = this.vector.getValue(row))) {
            this.value = tmp;
            this.currentColorScheme = this.rowValueToColorScheme.get(this.value);
            if (this.currentColorScheme == null) {
                this.currentColorScheme = this.rowValueToColorScheme.values().iterator().next().copy();
                this.currentColorScheme.setProject(this.project);
                this.rowValueToColorScheme.put(this.value, this.currentColorScheme);
            }
        }
        return this.currentColorScheme.getColor(row, column, val);
    }

    @Override
    public Color[] getColors() {
        return this.currentColorScheme.getColors();
    }

    @Override
    public Collection<DefaultElementPainter.Condition> getConditions(int row, int column) {
        return this.currentColorScheme.getConditions(row, column);
    }

    @Override
    public Dataset getDataset() {
        return this.currentColorScheme.getDataset();
    }

    @Override
    public String getDatasetName() {
        return this.currentColorScheme.getDatasetName();
    }

    public void setFirstRowValue() {
        this.setCurrentValue(this.firstValue);
    }

    @Override
    public float[] getFractions() {
        return this.currentColorScheme.getFractions();
    }

    @Override
    public float getGlobalMax() {
        return this.currentColorScheme.getGlobalMax();
    }

    @Override
    public float getGlobalMin() {
        return this.currentColorScheme.getGlobalMin();
    }

    @Override
    public JComponent getLegend() {
        return this.currentColorScheme.getLegend();
    }

    @Override
    public float getMax() {
        return this.currentColorScheme.getMax();
    }

    @Override
    public float getMin() {
        return this.currentColorScheme.getMin();
    }

    @Override
    public Color getMissingColor() {
        return this.currentColorScheme.getMissingColor();
    }

    @Override
    public String getName() {
        return this.currentColorScheme.getName();
    }

    @Override
    public Collection<DefaultElementPainter.Condition> getPredicateAndShapes() {
        return this.currentColorScheme.getPredicateAndShapes();
    }

    @Override
    public float getRowNormalizedMax() {
        return this.currentColorScheme.getRowNormalizedMax();
    }

    @Override
    public float getRowNormalizedMin() {
        return this.currentColorScheme.getRowNormalizedMin();
    }

    @Override
    public int getRowScalingMode() {
        return this.currentColorScheme.getRowScalingMode();
    }

    @Override
    public String getSeparateColorSchemesForColumnMetadataField() {
        return this.currentColorScheme.getSeparateColorSchemesForColumnMetadataField();
    }

    public String getSeparateColorSchemesForRowMetadataField() {
        return this.separateColorSchemesForRowMetadataField;
    }

    public Map<Object, HeatMapColorScheme> getValueToColorScheme() {
        return this.rowValueToColorScheme;
    }

    @Override
    public boolean isDiscrete() {
        return this.currentColorScheme.isDiscrete();
    }

    @Override
    public boolean isLogScale() {
        return this.currentColorScheme.isLogScale();
    }

    @Override
    public boolean isRelative() {
        return this.currentColorScheme.isRelative();
    }

    public void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void removeCondition(DefaultElementPainter.Condition p) {
        this.currentColorScheme.removeCondition(p);
        this.notifyListeners();
    }

    @Override
    public void setColors(Color[] colors) {
        this.currentColorScheme.setColors(colors);
    }

    @Override
    public void setColors(Color[] colors, float[] fractions) {
        this.currentColorScheme.setColors(colors, fractions);
    }

    public void setColorScheme(HeatMapColorScheme cs) {
        this.rowValueToColorScheme.put(this.value, cs);
        this.currentColorScheme = cs;
        this.setProject(this.project);
    }

    public void setCurrentValue(Object value) {
        if (this.firstValue == null) {
            this.firstValue = value;
        }
        this.value = value;
        this.currentColorScheme = this.rowValueToColorScheme.get(value);
        if (this.currentColorScheme == null) {
            this.currentColorScheme = this.rowValueToColorScheme.values().iterator().next().copy();
            this.currentColorScheme.setProject(this.project);
            this.rowValueToColorScheme.put(value, this.currentColorScheme);
        }
    }

    @Override
    public void setDatasetName(String datasetName) {
        this.currentColorScheme.setDatasetName(datasetName);
    }

    @Override
    public void setDiscrete(boolean discrete) {
        this.currentColorScheme.setDiscrete(discrete);
    }

    @Override
    public void setGlobalMax(float value) {
        this.currentColorScheme.setGlobalMax(value);
    }

    @Override
    public void setGlobalMin(float value) {
        this.currentColorScheme.setGlobalMin(value);
    }

    @Override
    public void setLogScale(boolean logScale) {
        this.currentColorScheme.setLogScale(logScale);
    }

    @Override
    public void setMissingColor(Color missingColor) {
        this.currentColorScheme.setMissingColor(missingColor);
    }

    @Override
    public void setName(String name) {
        this.currentColorScheme.setName(name);
    }

    @Override
    public void setProject(Project p) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = p;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
        } else {
            System.out.println("Project is null.");
        }
        for (HeatMapColorScheme cs : this.rowValueToColorScheme.values()) {
            cs.setProject(p);
        }
        this.updateDataset();
        this.notifyListeners();
    }

    @Override
    public void setRelative(boolean relative) {
        this.currentColorScheme.setRelative(relative);
    }

    @Override
    public void setRowNormalizedMax(float rowNormalizedMax) {
        this.currentColorScheme.setRowNormalizedMax(rowNormalizedMax);
    }

    @Override
    public void setRowNormalizedMin(float rowNormalizedMin) {
        this.currentColorScheme.setRowNormalizedMin(rowNormalizedMin);
    }

    @Override
    public void setRowScalingMode(int mode) {
        this.currentColorScheme.setRowScalingMode(mode);
    }

    @Override
    public void setSeparateColorSchemesForColumnMetadataField(String separateColorSchemesForColumnMetadataField) {
        this.currentColorScheme.setSeparateColorSchemesForColumnMetadataField(separateColorSchemesForColumnMetadataField);
    }

    public void setSeparateColorSchemesForRowMetadataField(String separateColorSchemesForRowMetadataField) {
        this.separateColorSchemesForRowMetadataField = separateColorSchemesForRowMetadataField;
        this.updateDataset();
        this.notifyListeners();
    }

    private void updateDataset() {
        if (this.project != null) {
            Dataset dataset = this.project.getSortedFilteredDataset();
            this.vector = dataset.getRowMetadata().get(this.separateColorSchemesForRowMetadataField);
        }
    }
}

